/* TODO / Erledigt Liste

 Done: Functions/Triggers
 Done: F2 / Standard-F2
 Done: Reports
 Done: DB-Updates
 Done: RTFs
 Done: System-Standard Sql


 Offen: Tables / Views
 Offen: Eine Funktion über alles

--Beispiel Fremdschlüsselbeziehungen suchen
 SELECT
    tc.table_name, kcu.column_name,
    ccu.table_name AS foreign_table_name,
    ccu.column_name AS foreign_column_name
 FROM
    information_schema.table_constraints AS tc
    JOIN information_schema.key_column_usage
        AS kcu ON tc.constraint_name = kcu.constraint_name
    JOIN information_schema.constraint_column_usage
        AS ccu ON ccu.constraint_name = tc.constraint_name
 WHERE constraint_type = 'FOREIGN KEY';

*/

--Das TSystem-Schema anlegen

-- postgresql version für systemweichen für kommende versionen
CREATE OR REPLACE FUNCTION TSystem.postgresqlVersion() RETURNS INT AS $$
  SELECT
    (CASE WHEN split_part(s,'.',1)::integer > 9 THEN
      split_part(s,'.',1) || '0'
     ELSE
      split_part(s,'.', 1) || split_part(s,'.', 2)
     END)::INT
    FROM substring(version(), E'PostgreSQL ([0-9\.]+)') AS s;
  $$ LANGUAGE sql STABLE;
--


--

--
 -- DROP FUNCTION IF EXISTS  TSystem.Prodatversion();
CREATE OR REPLACE FUNCTION TSystem.Prodatversion(
      OUT versionstring varchar,
      OUT main varchar,
      OUT major varchar,
      OUT minor varchar,
      OUT patchlevel varchar,
      OUT custombuild varchar,
      OUT revision integer
  ) RETURNS record AS $$
  BEGIN
      --
      versionstring := coalesce( nullif( tsystem.settings__get( 'ProdatVersion' ) ,'' ), '00.00.00.00' );
      major         := coalesce( nullif( tsystem.settings__get( 'MajorVersion' ) ,'' ), '00' );
      minor         := coalesce( nullif( tsystem.settings__get( 'MinorVersion' ) ,'' ), '00' );

      main          := Major || '.' || Minor;

      patchlevel    := coalesce( nullif( tsystem.settings__get( 'PatchVersion' ) ,'' ), '00');
      custombuild   := coalesce( nullif( tsystem.settings__get( 'CustomBuildVersion' ) ,'' ), '00' );

      -- Revision wird nicht mehr in den Settings gespeichert
      revision      := null;

      RETURN;

 END $$ LANGUAGE plpgsql STABLE;

--
CREATE OR REPLACE FUNCTION TSystem.current_user_ll_db_usename(in_return_current_user_on_null BOOL DEFAULT false) RETURNS VARCHAR(30) AS $$
  DECLARE usename VARCHAR;
  BEGIN
    SELECT ll_db_usename INTO usename FROM llv WHERE ll_db_usename = current_user;
    IF usename IS NULL AND in_return_current_user_on_null THEN --alle daten, welche intern zu nachverfolgung sind müssen immer ein login haben
       RETURN current_user;
    ELSE  --alle Ansprechpartner - für externe Dokumente sind nur gültig, wenn kontaktdaten. daher diese immer zu NULL wenn keine gültigen logins
       RETURN usename; --NULL, wenn kein gültiges Login
    END IF;
  END $$ LANGUAGE plpgsql STABLE;
--
/*Einstellungen aus der Settings laden*/


CREATE OR REPLACE FUNCTION TSystem.Settings__BASIS_W__Get()
    RETURNS varchar(20)
    AS $$
        SELECT coalesce(
                    ( SELECT s_inha::varchar(20) FROM public.settings WHERE upper( s_vari ) = 'BASIS_W'),
                    ''
               );
    $$ LANGUAGE sql STABLE PARALLEL SAFE; -- ACHTUNG Planner baut MIST ohne Stable und macht SeqScan


CREATE OR REPLACE FUNCTION TSystem.Settings__GetText( vari varchar, defvalue varchar DEFAULT '' )
    RETURNS text
    AS $$
        SELECT coalesce(
                    ( SELECT s_inha FROM public.settings WHERE upper( s_vari ) = upper( vari )),
                    defvalue
               );
    $$ LANGUAGE sql PARALLEL SAFE; -- KEIN Stable, da Änderungen innerhalb Trigger sonst nicht bemerkt werden im nächsten Trigger

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetTextSetting(vari varchar) RETURNS text AS $$
        SELECT TSystem.Settings__GetText(vari);
        $$ LANGUAGE sql PARALLEL SAFE;

-- Hinweis: Begrenzung von den 8191 Zeichen, im PgDAC, bei vom VARCHAR ohne  Längenangabe.
CREATE OR REPLACE FUNCTION TSystem.Settings__Get(vari varchar)
    RETURNS varchar
    AS $$
        SELECT TSystem.Settings__GetText(vari);
    $$LANGUAGE sql PARALLEL SAFE; -- muss Stable, da Planner sonst mist macht zB mit BASIS_W. Ergibt auch keinen Sinn Unstable. Braucht man tatsächlich innerhalb eines Statements unterschiedliche Ergebnisse, muss der Fall separat betrachtet werden!

--- #22886
CREATE OR REPLACE FUNCTION TSystem.Settings__Get__cascade_save( IN vari varchar )
    RETURNS varchar
    AS $$
        SELECT TSystem.Settings__Get( vari );
    $$LANGUAGE sql PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetSetting(vari varchar) RETURNS varchar AS $$
        SELECT TSystem.Settings__Get(vari);
        $$ LANGUAGE sql PARALLEL SAFE;


CREATE OR REPLACE FUNCTION TSystem.Settings__ENUM__Get(vari varchar, value varchar) RETURNS bool AS $$
    BEGIN
        RETURN TSystem.ENUM_GetValue(TSystem.Settings__Get(vari), value);
    END$$LANGUAGE plpgsql PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetEnumSetting(vari varchar, value varchar) RETURNS bool AS $$
        SELECT TSystem.Settings__ENUM__Get(vari, value);
        $$ LANGUAGE sql PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.Settings__ENUM__Get(vari varchar) RETURNS SETOF varchar AS $$
    BEGIN
        RETURN QUERY SELECT unnest(string_to_array(coalesce(TSystem.Settings__Get(vari), ''), ',')::varchar[]);
    END$$LANGUAGE plpgsql PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetEnumSetting(vari varchar) RETURNS SETOF varchar AS $$
        SELECT TSystem.Settings__ENUM__Get(vari);
        $$ LANGUAGE sql PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.Settings__GetInteger(vari varchar, defvalue integer DEFAULT 0) RETURNS integer AS $$
    DECLARE r varchar;
    BEGIN
        SELECT s_inha INTO r FROM public.settings WHERE s_vari=vari;
        IF NOT public.isnumeric(r) THEN --public wegen dump/restore
               RETURN defvalue;
        END IF;

        RETURN coalesce(CAST(r AS integer), defvalue);
    -- ist "parallel unsafe", da es die parallel unsafe Funktion IsNumeric verwendet (#21507)
    END $$ LANGUAGE plpgsql; -- TODO ab PG16 auf parallel safe zurück siehe IsNumeric (https://www.postgresql.org/docs/devel/functions-info.html#FUNCTIONS-INFO-VALIDITY)

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetIntegerSetting(vari varchar, defvalue integer DEFAULT 0) RETURNS integer AS $$
        SELECT TSystem.Settings__GetInteger(vari, defvalue);
        $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION TSystem.Settings__GetNumeric(vari varchar) RETURNS numeric AS $$
    DECLARE r numeric;
    BEGIN
      BEGIN
          SELECT coalesce(s_num_inha, s_inha::numeric) INTO r FROM public.settings WHERE s_vari = vari;
      EXCEPTION
          WHEN OTHERS THEN
              BEGIN
                  RETURN 0;
              END;
      END;

      RETURN coalesce(r, 0);
    END $$ LANGUAGE plpgsql PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetNumericSetting(vari varchar) RETURNS numeric AS $$
        SELECT TSystem.Settings__GetNumeric(vari);
        $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION TSystem.Settings__GetBool(vari varchar, defvalue boolean DEFAULT false) RETURNS boolean AS $$
    DECLARE r boolean;
            s varchar;
    BEGIN
       SELECT s_inha INTO s FROM public.settings WHERE s_vari = vari;
       --
       IF NOT FOUND THEN
              RETURN defvalue;
       END IF;
       --
       IF UPPER(s) IN ('-1','1', 'T', 'TRUE') THEN
              RETURN true;
       ELSE
              RETURN false;
       END IF;
    END$$LANGUAGE plpgsql PARALLEL SAFE;

--- #22886
CREATE OR REPLACE FUNCTION TSystem.Settings__GetBool__cascade_save(
    IN vari        varchar,
    IN defvalue    boolean default false
  ) RETURNS boolean AS $$

    SELECT TSystem.Settings__GetBool( vari, defvalue );

 $$ LANGUAGE SQL;
---

    CREATE OR REPLACE FUNCTION Z_99_Deprecated.GetBoolSetting(vari varchar, defvalue boolean DEFAULT false) RETURNS boolean AS $$
        SELECT TSystem.Settings__GetBool(vari, defvalue);
        $$ LANGUAGE sql PARALLEL SAFE;


CREATE OR REPLACE FUNCTION TSystem.Settings__ENUM__Set(vari VARCHAR, value VARCHAR) RETURNS VOID AS $$
  BEGIN
    PERFORM TSystem.Settings__Set(vari, TSystem.ENUM_SetValue(TSystem.Settings__Get(vari), value));
    RETURN;
  END$$LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetEnumSetting(vari VARCHAR, value VARCHAR) RETURNS VOID AS $$
    SELECT TSystem.Settings__ENUM__Set(vari, value);
   $$ LANGUAGE sql;


CREATE OR REPLACE FUNCTION TSystem.Settings__ENUM__Set(vari VARCHAR, value VARCHAR, enabled BOOL) RETURNS VOID AS $$
  BEGIN
    IF enabled THEN
      PERFORM TSystem.Settings__Set(vari, TSystem.ENUM_SetValue(TSystem.Settings__Get(vari), value));
    ELSE
      PERFORM TSystem.Settings__Set(vari, TSystem.ENUM_DelValue(TSystem.Settings__Get(vari), value));
    END IF;
    RETURN;
  END$$LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetEnumSetting(vari VARCHAR, value VARCHAR, enabled BOOL) RETURNS VOID AS $$
    SELECT TSystem.Settings__ENUM__Set(vari, value, enabled);
    $$ LANGUAGE sql;
--

-- Setting als BOOL setzen
CREATE OR REPLACE FUNCTION TSystem.Settings__Set(vari VARCHAR, inha BOOL) RETURNS VOID AS $$
  BEGIN
    IF inha IS NULL THEN
        PERFORM TSystem.Settings__Delete(vari);
        RETURN;
    END IF;
    IF inha THEN
        PERFORM TSystem.Settings__Set(vari, '-1');  -- true
    ELSE
        PERFORM TSystem.Settings__Set(vari, '0');   -- false
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetSetting(vari VARCHAR, inha BOOL) RETURNS VOID AS $$
      SELECT TSystem.Settings__Set(vari, inha);
    $$ LANGUAGE sql;
--

-- Setting als VARCHAR setzen
CREATE OR REPLACE FUNCTION TSystem.Settings__Set(vari VARCHAR, inha VARCHAR) RETURNS VOID AS $$
  DECLARE num NUMERIC;
  BEGIN
    IF inha IS NULL THEN
        PERFORM TSystem.Settings__Delete(vari);
        RETURN;
    END IF;
    IF EXISTS(SELECT true FROM public.settings WHERE s_inha = inha AND s_vari = vari) THEN
        RETURN;
    END IF;
    BEGIN
        num:= inha::NUMERIC(20,8); -- Cast auf max. Numeric versuchen. Länge entspr. Standard für interne Werte.
    EXCEPTION
        WHEN OTHERS THEN num:= NULL;
    END;
    UPDATE settings SET s_inha= inha, s_num_inha= num WHERE s_vari = vari;
    IF NOT FOUND THEN
        INSERT INTO settings (s_vari, s_inha, s_num_inha) VALUES (vari, inha, num);
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetSetting(vari VARCHAR, inha VARCHAR) RETURNS VOID AS $$
      SELECT TSystem.Settings__Set(vari, inha);
    $$ LANGUAGE sql;
--

-- Setting als INTEGER setzen
CREATE OR REPLACE FUNCTION TSystem.Settings__Set(vari VARCHAR, inha INTEGER) RETURNS VOID AS $$
  DECLARE num NUMERIC;
  BEGIN
    IF inha IS NULL THEN
        PERFORM TSystem.Settings__Delete(vari);
        RETURN;
    END IF;
    IF EXISTS(SELECT true FROM public.settings WHERE s_inha = inha::VARCHAR AND s_vari = vari) THEN
        RETURN;
    END IF;
    BEGIN
        num:= inha::NUMERIC(20,8); -- Cast auf max. Numeric versuchen. Länge entspr. Standard für interne Werte.
    EXCEPTION
        WHEN OTHERS THEN num:= NULL;
    END;
    UPDATE settings SET s_inha= inha::VARCHAR, s_num_inha= num WHERE s_vari = vari;
    IF NOT FOUND THEN
        INSERT INTO settings (s_vari, s_inha, s_num_inha) VALUES (vari, inha::VARCHAR, num);
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetSetting(vari VARCHAR, inha INTEGER) RETURNS VOID AS $$
      SELECT TSystem.Settings__Set(vari, inha);
    $$ LANGUAGE sql;
--

-- Wie SetSetting, nur ohne die maximale Begrenzung von den 8191 Zeichen, im PgDAC, bei vom VARCHAR ohne Längenangabe.
CREATE OR REPLACE FUNCTION TSystem.Settings__SetText(vari VARCHAR, inha TEXT) RETURNS VOID AS $$
  DECLARE num NUMERIC;
  BEGIN
    IF inha IS NULL THEN
        PERFORM TSystem.Settings__Delete(vari);
        RETURN;
    END IF;
    IF EXISTS(SELECT true FROM public.settings WHERE s_inha = inha AND s_vari = vari) THEN
        RETURN;
    END IF;
    BEGIN
        num:= inha::NUMERIC(20,8); -- Cast auf max. Numeric versuchen. Länge entspr. Standard für interne Werte.
    EXCEPTION
        WHEN OTHERS THEN num:= NULL;
    END;
    UPDATE settings SET s_inha= inha, s_num_inha= num WHERE s_vari = vari;
    IF NOT FOUND THEN
        INSERT INTO settings (s_vari, s_inha, s_num_inha) VALUES (vari, inha, num);
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetTextSetting(vari VARCHAR, inha TEXT) RETURNS VOID AS $$
      SELECT TSystem.Settings__SetText(vari, inha);
    $$ LANGUAGE sql;
--

--
CREATE OR REPLACE FUNCTION TSystem.Settings__SetNumeric(vari VARCHAR, inha NUMERIC) RETURNS VOID AS $$
  DECLARE num NUMERIC;
  BEGIN
    IF inha IS NULL THEN
        PERFORM TSystem.Settings__Delete(vari);
        RETURN;
    END IF;
    IF EXISTS(SELECT true FROM public.settings WHERE s_inha = inha::VARCHAR AND s_vari = vari) THEN
        RETURN;
    END IF;
    BEGIN
        num:= inha::NUMERIC(20,8); -- Cast auf max. Numeric versuchen. Länge entspr. Standard für interne Werte.
    EXCEPTION
        WHEN OTHERS THEN num:= NULL;
    END;
    UPDATE settings SET s_inha= inha::VARCHAR, s_num_inha= num WHERE s_vari = vari;
    IF NOT FOUND THEN
        INSERT INTO settings (s_vari, s_inha, s_num_inha) VALUES (vari, inha::VARCHAR, num);
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.SetNumericSetting(vari VARCHAR, n NUMERIC) RETURNS VOID AS $$
      SELECT TSystem.Settings__SetNumeric(vari, n);
    $$ LANGUAGE sql;
--

--
CREATE OR REPLACE FUNCTION TSystem.Settings__Delete(vari VARCHAR) RETURNS VOID AS $$
  BEGIN
    DELETE FROM public.settings WHERE s_vari = vari;
    RETURN;
  END $$ LANGUAGE plpgsql;

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.DelSetting(vari VARCHAR) RETURNS VOID AS $$
      SELECT TSystem.Settings__Delete(vari);
    $$ LANGUAGE sql;
--

--
CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, varchar, varchar)
    RETURNS varchar
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, numeric, numeric)
    RETURNS numeric
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, integer, integer)
 --ACHTUNG NUMERIC RÜCKGABE, da sonst Division Ganzzahlig machen würde und Nachkommastellen verschwinden!!!!! NUMERIC IST KORREKT!!!!
    RETURNS numeric
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END::numeric;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.IfThenInt(bool, integer, integer)
    RETURNS integer
    AS $$
        SELECT TSystem.IfThen($1, $2, $3)::integer;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, bool, bool)
    RETURNS bool
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, date, date)
    RETURNS date
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;


CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, timestamp, timestamp)
    RETURNS timestamp
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;


CREATE OR REPLACE FUNCTION TSystem.IfThen(bool, interval, interval)
    RETURNS interval
    AS $$
        SELECT CASE WHEN $1 THEN
                     $2
                    ELSE
                     $3
               END;
    $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

--
-- Prüft ob Tabelle 'tablename' eine Spalte namens 'ColumnName' hat
CREATE OR REPLACE FUNCTION tsystem.column_exists(
      _table_name  text,
      _column_name text,
      _schema_name text = 'public'
  ) RETURNS bool AS $$
  DECLARE
      _table regclass;
  BEGIN
      IF
             _table_name IS NULL
          OR _column_name IS NULL
          OR _schema_name IS NULL
      THEN
          RAISE EXCEPTION 'null is invalid parameter';
      END IF;

      IF NOT tsystem.table_exists( _table_name, _schema_name ) THEN
          RAISE EXCEPTION 'table »%.%« does not exist', _schema_name, _table_name;
      END IF;

      -- this casts the fully qualified name to regclass type
      _table =  _schema_name || '.' || _table_name;

      RETURN EXISTS (
         SELECT true
           FROM pg_catalog.pg_attribute
          WHERE
                attrelid = _table
            AND attname  = _column_name
            AND attisdropped IS false
            AND attnum > 0
       );

  END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION z_99_deprecated.column_exists(
      _colname text,
      _tablename text
  ) RETURNS bool AS $$

      SELECT tsystem.column_exists( _colname, _tablename )

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION tsystem.table_exists(
      _table_name  text,
      _schema_name text = null
  ) RETURNS bool AS $$
  DECLARE
    _search_path text[] = array[ _schema_name ]::text[];
    _schema text;
  BEGIN

      IF ( _schema_name IS NULL ) THEN

          -- remove null from array
          _search_path = array[]::text[];

          FOR _schema IN
               SELECT unnest( ('{' || current_setting('search_path') || '}')::text[] )
           LOOP
              -- translate special $user schema
              IF _schema = '"$user"' THEN
                  _schema := current_user;
              END IF;

              _search_path :=
                  array_append(
                    _search_path ,
                    trim( BOTH '"' FROM _schema )
                  );

           END LOOP;

      END IF;

      RETURN EXISTS (
        SELECT true
          FROM pg_catalog.pg_class c
          JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace
         WHERE
               n.nspname = any( _search_path )
           AND c.relname = _table_name
               -- only tables
           AND c.relkind = 'r'
      );

  END $$ LANGUAGE plpgsql STABLE;


CREATE OR REPLACE FUNCTION tsystem.schema_exists(
      _schema_name text
  ) RETURNS bool AS $$

      SELECT EXISTS (
        SELECT true
          FROM pg_catalog.pg_namespace
         WHERE nspname = _schema_name
      );

  $$ LANGUAGE sql STABLE;


-- CreateKeyword
CREATE OR REPLACE FUNCTION TSystem.CreateKeyword(IN rkategorie VARCHAR, IN rtablename VARCHAR, IN rdescr VARCHAR, IN rdbrid VARCHAR, IN rvalue VARCHAR, IN pname VARCHAR, IN runit VARCHAR DEFAULT NULL) RETURNS VOID AS $$
 BEGIN
  UPDATE RecNoKeyword SET r_kategorie=rkategorie, r_value=rvalue, r_unit=runit, r_descr=rdescr
                      WHERE r_tablename=rtablename AND r_dbrid=rdbrid AND r_reg_pname=pname;
  IF NOT FOUND THEN
    INSERT INTO RecNoKeyword(r_kategorie, r_tablename, r_descr, r_dbrid, r_value, r_reg_pname, r_unit)
                     VALUES (rkategorie,  rtablename,  rdescr,  rdbrid,  rvalue,  pname,       runit);
  END IF;
  RETURN;
 END $$ LANGUAGE plpgsql;

-- DeleteKeyword
CREATE OR REPLACE FUNCTION TSystem.DeleteKeyword(IN rkategorie VARCHAR, IN rdbrid VARCHAR, IN rdescr VARCHAR, IN pname VARCHAR DEFAULT NULL) RETURNS VOID AS $$
 BEGIN
  DELETE FROM RecNoKeyword WHERE r_kategorie=rkategorie AND r_dbrid=rdbrid  AND r_descr=rdescr AND r_reg_pname IS NOT DISTINCT FROM COALESCE(pname, r_reg_pname);
  RETURN;
 END $$ LANGUAGE plpgsql;


-- Parameterwerte einer Funktion aus PG-Catalog raussuchen und anzeigen
CREATE OR REPLACE FUNCTION TSystem.Function_Args(
  IN funcOID    OID,
  OUT pos       integer,
  OUT direction VARCHAR,
  OUT argname   VARCHAR,
  OUT datatype  VARCHAR)
 RETURNS SETOF RECORD AS $$
 DECLARE
  rettype character varying;
  argtypes oidvector;
  allargtypes oid[];
  argmodes "char"[];
  argnames text[];
  mini integer;
  maxi integer;
 BEGIN

  IF TSystem.postgresqlVersion() < 110 THEN
    /* get object ID of function */
    SELECT INTO rettype, argtypes, allargtypes, argmodes, argnames
           CASE
                  WHEN pg_proc.proretset THEN 'setof ' || pg_catalog.format_type(pg_proc.prorettype, NULL)
                  ELSE pg_catalog.format_type(pg_proc.prorettype, NULL)
           END,
           pg_proc.proargtypes,
           pg_proc.proallargtypes,
           pg_proc.proargmodes,
           pg_proc.proargnames
      FROM pg_catalog.pg_proc
           JOIN pg_catalog.pg_namespace ON (pg_proc.pronamespace = pg_namespace.oid)
     WHERE pg_proc.prorettype <> 'pg_catalog.cstring'::pg_catalog.regtype
       AND (pg_proc.proargtypes[0] IS NULL
        OR pg_proc.proargtypes[0] <> 'pg_catalog.cstring'::pg_catalog.regtype)
       AND NOT pg_proc.proisagg
       AND pg_proc.oid = funcOID
       --AND pg_catalog.pg_function_is_visible(pg_proc.oid)
    ;    /* get object ID of function */
  ELSE
    SELECT INTO rettype, argtypes, allargtypes, argmodes, argnames
           CASE
                  WHEN pg_proc.proretset THEN 'setof ' || pg_catalog.format_type(pg_proc.prorettype, NULL)
                  ELSE pg_catalog.format_type(pg_proc.prorettype, NULL)
           END,
           pg_proc.proargtypes,
           pg_proc.proallargtypes,
           pg_proc.proargmodes,
           pg_proc.proargnames
      FROM pg_catalog.pg_proc
           JOIN pg_catalog.pg_namespace ON (pg_proc.pronamespace = pg_namespace.oid)
     WHERE pg_proc.prorettype <> 'pg_catalog.cstring'::pg_catalog.regtype
       AND (pg_proc.proargtypes[0] IS NULL
        OR pg_proc.proargtypes[0] <> 'pg_catalog.cstring'::pg_catalog.regtype)
       AND pg_proc.prokind <> 'a'
       AND pg_proc.oid = funcOID
       --AND pg_catalog.pg_function_is_visible(pg_proc.oid)
    ;
  END IF;

  /* bail out if not found */
  IF NOT FOUND THEN
    RETURN;
  END IF;

  /* return a row for the return value */
  pos = 0;
  direction = 'OUT'::VARCHAR;
  argname = 'RETURN VALUE';
  datatype = rettype;
  RETURN NEXT;

  /* unfortunately allargtypes is NULL if there are no OUT parameters */
  IF allargtypes IS NULL THEN
    mini = array_lower(argtypes, 1); maxi = array_upper(argtypes, 1);
  ELSE
    mini = array_lower(allargtypes, 1); maxi = array_upper(allargtypes, 1);
  END IF;
  IF maxi < mini THEN RETURN; END IF;

  /* loop all the arguments */
  FOR i IN mini .. maxi LOOP
    pos = i - mini + 1;
    IF argnames IS NULL THEN
      argname = NULL;
    ELSE
      argname = argnames[pos];
    END IF;
    IF allargtypes IS NULL THEN
      direction = 'IN'::VARCHAR;
      datatype = pg_catalog.format_type(argtypes[i], NULL);
    ELSE
      IF (argmodes[i]='i') THEN
        direction = 'IN';
      ELSEIF (argmodes[i]='o') THEN
        direction = 'OUT';
      ELSEIF (argmodes[i]='b') THEN
        direction = 'BOTH';
      END IF;
      datatype = pg_catalog.format_type(allargtypes[i], NULL);
    END IF;
    RETURN NEXT;
  END LOOP;

  RETURN;
 END;$$ LANGUAGE plpgsql STABLE STRICT SECURITY INVOKER;
--

--
CREATE OR REPLACE FUNCTION TSystem.Search_FunctionOID(fname VARCHAR, paramCount INTEGER = null, pNames VARCHAR[] = NULL, fschema VARCHAR = NULL) RETURNS OID AS $$
 DECLARE rec RECORD;
        o   OID;
        i INTEGER;
 BEGIN
  i:=0;

  IF TSystem.postgresqlVersion() < 110 THEN
    FOR rec IN SELECT p.oid FROM pg_proc p
            LEFT JOIN pg_type t        ON t.oid = p.prorettype
            LEFT JOIN pg_namespace n   ON n.oid = p.pronamespace
            LEFT JOIN pg_description d ON p.oid = d.objoid
          WHERE -- pg_catalog.pg_function_is_visible(p.oid) AND
            n.nspname <> 'pg_catalog'
            AND n.nspname <> 'information_schema'
            AND p.prokind = 'f'
            AND t.typname <> 'trigger'
            AND n.nspname = COALESCE(LOWER(fschema),n.nspname)
            AND p.proname = Lower(fname)
            AND (p.proargnames @> (SELECT array_agg(q.ele) FROM (SELECT TRIM(LOWER(UNNEST(pNames)))::TEXT AS ele) AS q) -- @> ist contains, lowercase für Arrayelemente
                  OR pNames IS NULL)
            AND (p.pronargs = paramCount OR paramCount IS NULL)
    LOOP
      i:=i+1;
      o:=rec.oid;
      IF i > 1 THEN
       RAISE NOTICE 'TSystem.Search_FunctionOID(fname, paramCount, pNames, fschema): Hat kein eindeutiges Ergebnis zurückgegeben. Parameter und -anzahl bitte präzisieren.';
       RETURN NULL;
      END IF;
    END LOOP;
  ELSE
    FOR rec IN SELECT p.oid FROM pg_proc p
            LEFT JOIN pg_type t        ON t.oid = p.prorettype
            LEFT JOIN pg_namespace n   ON n.oid = p.pronamespace
            LEFT JOIN pg_description d ON p.oid = d.objoid
          WHERE -- pg_catalog.pg_function_is_visible(p.oid) AND
            n.nspname <> 'pg_catalog'
            AND n.nspname <> 'information_schema'
            AND p.prokind <> 'a'
            AND t.typname <> 'trigger'
            AND n.nspname = COALESCE(LOWER(fschema),n.nspname)
            AND p.proname = Lower(fname)
            AND (p.proargnames @> (SELECT array_agg(q.ele) FROM (SELECT TRIM(LOWER(UNNEST(pNames)))::TEXT AS ele) AS q) -- @> ist contains, lowercase für Arrayelemente
                  OR pNames IS NULL)
            AND (p.pronargs = paramCount OR paramCount IS NULL)
    LOOP
      i:=i+1;
      o:=rec.oid;
      IF i > 1 THEN
       RAISE NOTICE 'TSystem.Search_FunctionOID(fname, paramCount, pNames, fschema): Hat kein eindeutiges Ergebnis zurückgegeben. Parameter und -anzahl bitte präzisieren.';
       RETURN NULL;
      END IF;
    END LOOP;
  END IF;



  RETURN o;
 END $$ LANGUAGE plpgsql STABLE;

 --SELECT TSystem.Search_FunctionOID('auftg_pos_wert_calc', 6, ARRAY['agid','offen','basis_w','withtotalpos']) -- Es gibt die Funktion 4mal, mit 3,4,5,6 Parametern
--

--
CREATE OR REPLACE FUNCTION TSystem.Create_FComment(
    IN fname      VARCHAR,                      -- 'Schema.Funcname', Schema kann weggelassen werden. Bsp: "TSystem.Create_FComment" oder "Create_FComment"
    IN summary    VARCHAR,                      -- Kurzzusammenfassung, was die Funktion macht
    IN returns    VARCHAR   DEFAULT NULL,       -- Beschreibung des Rückgabewertes (eher inhaltlich, z.Bsp: "Gibt als Umrechnungsfaktor 0 statt NULL zurück wenn nichts gefunden wird" ... )
    IN pCount     INTEGER   DEFAULT NULL,       -- Anzahl der Parameter (Eindeutigkeit erzeugen bei unvollständiger Angabe der pNames)
    IN pNames     VARCHAR[] DEFAULT NULL,       -- Auflistung der Parameternamen von IN, OUT und INOUT Parameter der Funktion (Muss nicht vollständig sein)
    IN pDescr     VARCHAR[] DEFAULT NULL,       -- Beschreibung der Parameter in der Reihenfolge, die in pNames angegeben ist
    IN keyWords   VARCHAR[] DEFAULT NULL,       -- Schlüsselworte, unter denen die Funktion einsortiert wird
    IN example    VARCHAR   DEFAULT NULL,       -- Ein erläuternder Beispielsaufruf
    IN remarks    VARCHAR   DEFAULT NULL        -- Zusätzliche Bemerkungen
 ) RETURNS VARCHAR AS $$
 DECLARE fOID     OID;
         --pCount   INTEGER;
         cmnt     TEXT;
         i        INTEGER;
         fschema   VARCHAR;
         funcname VARCHAR;
 BEGIN

   --Eingabe  Name = 'TSystem.Create_Blubb' => beim Punkt splitten, wenn zwei Teile da sind, Schemaname merken
   IF array_length (regexp_split_to_array(fname, '\\.'),1) > 1 THEN
     fschema  :=(regexp_split_to_array(fname, '\\.'))[0];
     funcname:=(regexp_split_to_array(fname, '\\.'))[1];
   ELSE
     fschema := NULL;
     funcname:= fName;
   END IF;


   IF current_user = 'root' THEN RAISE NOTICE 'TSystem.Create_FComment für Funktion %, Schema %',funcname,fschema; END IF;


   -- nicht machen, damit eine unvollständige Angabe von kommentierten Parametern möglich ist.
   --IF pNames IS NOT NULL THEN
   --  pCount:=array_upper(pNames,1);
   --END IF;

   foid:=TSystem.Search_FunctionOID(funcName, pCount, pNames, fschema);
   IF foid IS NULL THEN
     RAISE EXCEPTION 'TSystem.Create_FComment: %', lang_text(29143);  -- Funktionskommentar konnte nicht erstellt werden, da die OID der Funktion nicht ermittelt werden konnte. Parameter und -anzahl bitte präzisieren.'
   END IF;

   --cmnt aufbauen => JSON Syntax!
   cmnt:='{';
   cmnt:=cmnt || E'\r\n' || '"summary" : "' || COALESCE(summary,'') || '",';
   cmnt:=cmnt || E'\r\n' || '"returns" : "' || COALESCE(returns,'') || '",';
   --
   cmnt:=cmnt || E'\r\n' || '"params"  : [';

   --parameter-array durchlaufen und
   IF pNames IS NOT NULL THEN
       FOR i IN array_lower(pNames, 1) .. array_upper(pNames, 1) LOOP
         cmnt:=cmnt || E'\r\n' || '{ "name"  : "'||pNames[i]||'",';
         IF array_upper(pDescr,1) >= array_upper(pNames, 1) THEN
           cmnt:=cmnt          ||  ' "descr" : "'||pDescr[i]||'"}';
         END IF;
         IF i<> array_upper(pNames, 1) THEN--damit nach letztem kein komma
           cmnt:=cmnt || ',';
         END IF;
       END LOOP;
   END IF;

   cmnt:=cmnt || '],';

   cmnt:=cmnt || E'\r\n' || '"example" : "' || COALESCE(example,'') || '",';
   cmnt:=cmnt || E'\r\n' || '"remarks" : "' || COALESCE(remarks,'') || '",';

   cmnt:=cmnt || E'\r\n' || '"keywords": [';
   IF keyWords IS NOT NULL THEN
       FOR i IN array_lower(keyWords, 1) .. array_upper(keyWords, 1) LOOP
         cmnt:=cmnt || '"'||keyWords[i]||'"';
         IF i<> array_upper(keyWords, 1) THEN
           cmnt:=cmnt || ',';
         END IF;
       END LOOP;
   END IF;
   cmnt:=cmnt || ']';

   cmnt:=cmnt || E'\r\n' || '}';

   IF current_user = 'root' THEN RAISE NOTICE '%',cmnt; END IF;

   --Kommentar schreiben
   --schreibt in Tabelle wie "COMMENT ON x IS ""
   UPDATE pg_description SET description = cmnt WHERE objoid = fOID;
   IF NOT FOUND THEN
     INSERT INTO pg_description (objoid,classoid,objsubid,description) VALUES (fOID, 1255, 0 , cmnt); -- 1255 = pg_class, ID = pg_proc
   END IF;

   RETURN cmnt;
 END $$ LANGUAGE plpgsql VOLATILE;
--

--
SELECT TSystem.Create_FComment( 'Create_FComment',
    'Die Funktion erzeugt einen Kommentar für Datenbankfunktionen in strukturierter Form (JSON).',
    'Den erzeugten Kommentar als JSON-String.',
    9,
    ARRAY['fname','summary','returns','pCount','pNames','pDescr','keyWords','example','remarks'],
    ARRAY['Name der Datenbankfunktion für die ein Kommentar erstellt werden soll.',
          'Schema dem die Funktion zugeordnet ist.',
          'Beschreibung / Zusammenfassung der Aufgabe, die die Funktion erfüllt.',
          'Anzahl der Parameter (für Eindeutigkeit der Funktion)',
          'Beschreibung des Rückgabewertes der Funktion oder von Besonderheiten die bei der Rückgabe zu beachten sind.',
          'Varchar-Array mit den Namen der Eingangsparameter',
          'Varchar-Array mit der Beschreibung einzelner Parameter',
          'Schlüsselworte, die für die Suche nach der Funktion benutzt werden. Bsp. Preis, Auftrag, Umrechnung, System',
          'Ein Beispielaufruf, wie die Funktion benutzt werden kann.',
          'Ergänzende Hinweise zur Benutzung der Funktion. '
    ],
    ARRAY['System','Kommentar','Comment','Dokumentation'],
    ' ... zu kompliziert.',
    ' Die Create_FComment-Funktion zum Erstellen eines Kommentars für die Create_FComment Funktion zu benutzen und damit gleich ihre Funktion zu dokumentieren, ist ja wohl sowas von 1337 ... '
    );
--

-- Suche nach SQL-Funktionen auf DB per pg_catalog
-- DROP FUNCTION IF EXISTS TSystem.Search_Functions(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_Functions(
      _p_search_strings     text,
      _p_case_insensitive   boolean,

      OUT elementID         varchar,
      OUT elementName       varchar,
      OUT description       varchar,
      OUT matching_terms    varchar,
      OUT function_def      text
  ) RETURNS SETOF record AS $$
  DECLARE
      x                     record;
      qry                   text;
      v_matches             text;
      v_search_strings      text    := _p_search_strings;
      v_case_insensitive    boolean := _p_case_insensitive;
      v_funcdef             text;
  BEGIN
      -- v_search_strings IS a list, pipe-separated, exactly what we want to search against.
      -- NOTE: works on postgresql v8.4
      -- Example: SELECT * FROM search_public_functions( 'crosstab|intersect|except|ctid', true );

      IF v_case_insensitive IS NOT FALSE THEN
          v_case_insensitive := true;
      END IF;

      -- Feature versionsabgängig
      IF TSystem.postgresqlVersion() < 110 THEN
          -- Query-String für früher PG-Versionen
          qry :=
            $QRY_109$
                SELECT
                  p.oid AS elementID,
                  n.nspname || '.' || p.proname AS elementName,
                  n.nspname || '.' || p.proname || ' ( ' || pg_catalog.pg_get_function_arguments( p.oid ) || ' )'::text AS description,
                  ( SELECT pg_catalog.pg_get_functiondef( p.oid ) ) AS funcdef
                FROM pg_catalog.pg_proc AS p
                  LEFT JOIN pg_catalog.pg_namespace AS n ON n.oid = p.pronamespace
                WHERE -- pg_catalog.pg_function_is_visible(p.oid) AND
                      n.nspname <> 'pg_catalog'
                  AND n.nspname <> 'information_schema'
                  AND NOT p.proisagg
                ORDER BY 1
            $QRY_109$
          ;

      ELSE
          -- Query-String für aktuelle PG-Versionen
          qry :=
            $QRY_110$
                SELECT
                  p.oid AS elementID,
                  n.nspname || '.' || p.proname AS elementName,
                  n.nspname || '.' || p.proname || ' ( ' || pg_catalog.pg_get_function_arguments( p.oid ) || ' )'::text AS description,
                  ( SELECT pg_catalog.pg_get_functiondef( p.oid ) ) AS funcdef
                FROM pg_catalog.pg_proc AS p
                  LEFT JOIN pg_catalog.pg_namespace AS n ON n.oid = p.pronamespace
                WHERE -- pg_catalog.pg_function_is_visible(p.oid) AND
                      n.nspname <> 'pg_catalog'
                  AND n.nspname <> 'information_schema'
                  AND p.prokind <> 'a'
                ORDER BY 1
            $QRY_110$
          ;

      END IF;

      IF _p_case_insensitive IS TRUE THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      -- Excute notwendig bzgl. Versionsunterscheidung
      FOR x IN EXECUTE qry LOOP
          elementID   := null;
          elementName := null;
          description := null;
          v_funcdef   := null;

          IF x.funcdef ~* v_search_strings THEN
              v_matches := null;
              v_funcdef := x.funcdef;

              IF _p_case_insensitive IS TRUE THEN
                  v_funcdef := lower( v_funcdef );
              END IF;

              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( v_funcdef, v_search_strings, 'g' ), ',' ) AS val ) AS y2
              ;

              elementID      := x.elementID;
              elementName    := x.elementName;
              description    := x.description;
              matching_terms := v_matches;
              function_def   := x.funcdef;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql SECURITY DEFINER;
--

--
-- DROP FUNCTION IF EXISTS TSystem.Search_F2Queries(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_F2Queries(
      _p_search_strings     text,
      _p_case_insensitive   boolean,

      OUT elementID         varchar,
      OUT elementName       varchar,
      OUT description       varchar,
      OUT matching_terms    varchar,
      OUT f2query           text,
      OUT standardf2        integer,
      OUT modulname         varchar,
      OUT feldname          varchar,
      OUT rtfid             integer,
      OUT changetext        text,
      OUT cimgray           boolean
  ) RETURNS SETOF record AS $$
 DECLARE
      x                     record;
      v_matches             text;
      v_search_strings      text    := _p_search_strings;
      v_case_insensitive    boolean := _p_case_insensitive;
  BEGIN
      -- v_search_strings IS a list, pipe-separated, exactly what we want to search against.
      -- NOTE: works on postgresql v8.4
      -- Example: SELECT * FROM search_public_functions('crosstab|intersect|except|ctid',true);

      IF v_case_insensitive IS NOT false THEN
          v_case_insensitive := true;
      END IF;

      IF _p_case_insensitive IS true THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      FOR x IN
          SELECT
            f2s_name AS elementID,
            coalesce( lang_text( f2s_name ), f2s_name::varchar ) AS elementName,
            'StandardF2.' || coalesce( lang_text( f2s_name ), f2s_name::varchar ) AS description,
            f2s_query::text AS f2query,
            f2s_name AS standardF2,
            '' AS modulname,
            '' AS feldname,
            wherescript AS rtf_id,
            '' AS changetext,
            f2s_deleted AS deleted
          FROM f2standard

          UNION
          SELECT
            f2_id AS elementID,
            ( coalesce( f2poss.modulname, '' ) || '.' || coalesce( f2poss.feldname, '' ) || '.' || coalesce( lang_text( vartxtnr ), vartxtnr::varchar ) ) AS elementName,
            ( 'F2Poss.' || coalesce( f2poss.modulname, '' ) || '.' || coalesce( f2poss.feldname, '' ) || '.' || coalesce( lang_text( vartxtnr ), vartxtnr::varchar ) ) AS description,
            f2_query ::text AS f2query,
            f2_standard AS standardf2,
            f2poss.modulname,
            f2poss.feldname,
            runtimeforms AS rtf_id,
            f2_changetext AS changetext,
            f2_deleted AS deleted
          FROM f2poss

          ORDER BY 1

      LOOP
          elementID   := null;
          elementName := null;
          description := null;
          f2query     := null;
          standardf2  := null;
          modulname   := null;
          feldname    := null;
          rtfid       := null;
          changetext  := null;

          IF  (
                -- F2-Query durchsuchen
                    x.f2query ~* v_search_strings
                -- Modulname durchsuchen
                OR  x.modulname ~* v_search_strings
                -- Feldname durchsuchen
                OR x.feldname ~* v_search_strings
                -- RTF
                OR x.rtf_id ~* v_search_strings
                -- Änderungshinweise durchsuchen
                OR x.changetext ~* v_search_strings
              )
          THEN
              v_matches := null;
              f2query := x.f2query;

              IF _p_case_insensitive IS true THEN
                  f2query := LOWER(f2query);
              END IF;

              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( f2query, v_search_strings, 'g' ), ',' ) AS val ) AS y2
              ;

              matching_terms := v_matches;
              elementID      := x.elementID;
              elementName    := coalesce( x.ElementName, 'leer?!?' );
              description    := x.description;
              f2query        := x.f2query;
              standardf2     := x.StandardF2;
              modulname      := x.modulname;
              feldname       := x.feldname;
              rtfid          := x.rtf_id;
              changetext     := x.changetext;
              cimgray        := x.deleted;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql SECURITY DEFINER;
--

-- #12371
-- DROP FUNCTION IF EXISTS TSystem.FastReport__blob__encode(bytea, text);
CREATE OR REPLACE FUNCTION TSystem.FastReport__blob__encode(
      _blob                 bytea,
      _p_search_strings     text,

      OUT fr_design_code    text,
      OUT fr_design_script  text
  ) RETURNS record AS $$
  DECLARE
    result text;
  BEGIN
      fr_design_code := encode( _blob, 'escape' );

      -- #12371, little performance
      IF fr_design_code LIKE E'\\\\377\\\\376%' THEN
          fr_design_code := replace( replace( fr_design_code, E'\\000', '' ), E'\\377\\376', '' );
      END IF;

      IF coalesce( position( _p_search_strings IN fr_design_code ), 0 ) = 0 THEN
          fr_design_code   := '0000'; -- null;
          fr_design_script := null;

          RETURN;
      END IF;

      IF fr_design_code LIKE '<?xml%' THEN
          BEGIN
              fr_design_script := xpath( '//TfrxReport/@ScriptText.Text', xmlparse( DOCUMENT _blob ) );
          EXCEPTION
              WHEN OTHERS THEN
          END;
      ELSE
          fr_design_script := null;
      END IF;

      RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Dokumente durchsuchen
CREATE OR REPLACE FUNCTION TSystem.Search_Reports(
      _p_search_strings       text,
      _p_case_insensitive     boolean,

      OUT elementID           varchar,
      OUT tablename           varchar,
      OUT r_stamp             varchar,
      OUT elementName         varchar,
      OUT description         varchar,
      OUT kunde               varchar,
      OUT matching_terms      varchar,
      OUT reportquery         text,
      OUT isReportSubDataSet  boolean,
      OUT reportID            integer,
      OUT modulname           varchar,
      OUT changetext          text,
      OUT r_wherertf          integer,
      OUT r_afterrtf          integer,
      OUT sql_beforescript    text,
      OUT sql_afterscript     text,
      OUT fr_design_code      text,
      OUT fr_design_script    text,
      OUT cimgray             boolean

  ) RETURNS SETOF record AS $$
  DECLARE
      x                       record;
      v_matches               text;
      v_search_strings        text    := _p_search_strings;
      v_case_insensitive      boolean := _p_case_insensitive;
  BEGIN
      IF v_case_insensitive IS NOT false THEN
          v_case_insensitive := true;
      END IF;

      -- Reports selber
      IF _p_case_insensitive IS true THEN
          v_search_strings := LOWER(v_search_strings);
      END IF;

      FOR x IN
          SELECT *
          FROM (
              SELECT
                r_id            AS elementID,
                r_id::varchar || '.' || coalesce( r_descr_text, r_descr::varchar ) AS elementName,
                coalesce( r_reportgen, '' ) || '-Report.' || r_id::varchar || '.' || coalesce( r_descr_text, r_descr::varchar ) || '.' || coalesce( r_detail, '' ) AS description,
                r_kunde         AS kunde,
                r_sql           AS reportquery,
                false           AS isReportSubDataSet,
                r_id            AS reportID,
                r_modulname     AS modulname,
                r_beforescript  AS sql_beforescript,
                r_afterscript   AS sql_afterscript,
                r_changetext    AS changetext,
                -- '' AS fr_design_code,
                -- '' AS fr_design_script
                fr_search.fr_design_code   AS fr_design_code,
                fr_search.fr_design_script AS fr_design_script,
                reports.r_stamp AS r_stamp,
                reports.r_wherertf::varchar,
                reports.r_afterrtf::varchar,
                r_deleted       AS deleted,
                'reports'       AS tablename

              FROM reports
                LEFT JOIN LATERAL lang_text ( r_descr ) AS r_descr_text ON r_descr IS NOT NULL

                -- Prüfung, ob LO für FastReport-Skript überhaupt existiert, siehe #15586.
                LEFT JOIN LATERAL (
                    SELECT
                      r_blob AS valid_r_blob
                    WHERE r_blob IS NOT NULL
                      AND EXISTS(SELECT true FROM pg_largeobject WHERE loid = r_blob)
                  ) AS lo_check ON true

                -- Wenn LO für FastReport-Script valide ist, dann öffnen und als Text zurückgeben.
                LEFT JOIN LATERAL TSystem.FastReport__blob__encode( lo_get( lo_check.valid_r_blob ), _p_search_strings ) AS fr_search ON lo_check.valid_r_blob IS NOT NULL

              UNION
              SELECT
                rl_id           AS elementID,
                rl_id::varchar || '.' || coalesce( r_descr_text, r_descr::varchar ) AS elementName,
                coalesce( r_reportgen,'' ) || '-Report.' || rl_id::varchar || '.' || coalesce( r_descr_text, r_descr::varchar ) || '.' || coalesce( rl_customdetail,'' ) AS description,
                r_kunde         AS kunde,
                rl_customsql    AS reportquery,
                false           AS isReportSubDataSet,
                r_id            AS reportID,
                rl_modulname    AS modulname,
                r_beforescript  AS sql_beforescript,
                r_afterscript   AS sql_afterscript,
                r_changetext    AS changetext,
                '', -- fr_design_code
                '', -- fr_design_script
                reports.r_stamp AS r_stamp,
                reports.r_wherertf::varchar,
                reports.r_afterrtf::varchar,
                false           AS deleted,
                'report_links'       AS tablename
              FROM reports
                JOIN report_links ON reports.r_stamp = rl_r_stamp
                LEFT JOIN LATERAL lang_text( r_descr ) AS r_descr_text ON r_descr IS NOT NULL

              UNION
              SELECT
                rds_id          AS elementID,
                coalesce( r_descr_text, r_descr::varchar ) || '.' || coalesce( rds_name,'' ) AS elementName,
                'Reportdataset.' || rds_id::varchar || '.' || coalesce( r_reportgen, '' ) || '-Report.' || rds_r_id::varchar || '.' || coalesce( r_descr_text, r_descr::varchar ) || '.' || coalesce( r_detail, '' ) || '.' || coalesce( rds_name, '' ) AS description,
                r_kunde         AS kunde,
                rds_sql         AS reportquery,
                true            AS isReportSubDataSet,
                rds_r_id        AS reportid,
                '', -- modulname
                '', -- sql_beforescript
                '', -- sql_afterscript
                '', -- changetext
                '', -- fr_design_code
                '', -- fr_design_script
                reports.r_stamp AS r_stamp,
                reports.r_wherertf::varchar,
                reports.r_afterrtf::varchar,
                false           AS deleted,
                'report_datasets'       AS tablename
              FROM reports
                LEFT JOIN report_datasets ON rds_r_id = r_id
                LEFT JOIN LATERAL lang_text( r_descr ) AS r_descr_text ON r_descr IS NOT NULL
          ) AS repsql
          ORDER BY reportid, NOT repsql.isReportSubDataSet
      LOOP
          IF  (
                -- Sql-durchsuchen
                    x.reportquery ~* v_search_strings
                -- Modulname durchsuchen
                OR  x.modulname ~* v_search_strings
                -- Änderungshinweise durchsuchen
                OR  x.changetext ~* v_search_strings
                -- Beforescript durchsuchen
                OR  x.sql_beforescript ~* v_search_strings
                -- Afterscript durchsuchen
                OR  x.sql_afterscript ~* v_search_strings
                -- Fastreport-Design durchsuchen
                OR  x.fr_design_code ~* v_search_strings
                -- RTF
                OR  x.r_wherertf ~* v_search_strings
                OR  x.r_afterrtf ~* v_search_strings
              )
          THEN
              v_matches   := null;
              reportquery := x.reportquery;

              IF _p_case_insensitive IS true THEN
                  reportquery := lower( reportquery );
              END IF;

              -- saves all pipe seperated elements which matched this result
              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM (
                  SELECT DISTINCT array_to_string( regexp_matches( reportquery, v_search_strings , 'g' ), ',' ) AS val
              ) AS y2
              ;

              matching_terms     := v_matches;
              tablename          := x.tablename;
              elementID          := x.elementID;
              elementName        := coalesce( x.elementName, 'leer?!?' );
              description        := x.description;
              kunde              := x.kunde;
              isReportSubDataSet := x.isReportSubDataSet;
              reportID           := x.reportID;
              reportquery        := x.reportquery;
              modulname          := x.modulname;
              changetext         := x.changetext;
              sql_beforescript   := x.sql_beforescript;
              sql_afterscript    := x.sql_afterscript;
              fr_design_code     := x.fr_design_code;
              r_stamp            := x.r_stamp::varchar;
              cimgray            := x.deleted;
              r_wherertf         := x.r_wherertf::integer;
              r_afterrtf         := x.r_afterrtf::integer;


              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql;
--

-- Suche in DB-Updates
-- DROP FUNCTION IF EXISTS TSystem.Search_DBUpdates(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_DBUpdates(
      _p_search_strings     text,
      _p_case_insensitive   boolean,

      OUT elementID         varchar,
      OUT elementName       varchar,
      OUT description       text,
      OUT matching_terms    varchar,
      OUT updquery          text,
      OUT upd_minver        varchar,
      OUT upd_txt           varchar,
      OUT parentUpdID       varchar
  ) RETURNS SETOF record AS $$
  DECLARE
      x                     record;
      v_matches             text;
      v_search_strings      text    := _p_search_strings;
      v_case_insensitive    boolean := _p_case_insensitive;
  BEGIN
      -- v_search_strings is a  list, pipe-separated, exactly what we want to search against.
      -- NOTE: works on postgresql v8.4
      -- Example: SELECT * FROM search_public_functions('crosstab|intersect|except|ctid',true);

      IF v_case_insensitive IS NOT FALSE THEN
          v_case_insensitive := true;
      END IF;

      IF _p_case_insensitive IS TRUE THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      FOR x IN
          SELECT
            upd_id::varchar AS elementID,
            upd_bez AS elementName,
            upd_id::varchar || '.' || coalesce( upd_bez,'' ) || '.' || ifthen( upd_noerr, 'NoERROR', '' ) || '.' || coalesce( upd_donedat::varchar, '' ) AS description,
            upd_sql AS updquery,
            dbupdates.upd_minver,
            dbupdates.upd_txt,
            upd_parent::varchar AS parentUpdID
          FROM dbupdates
          ORDER BY
            dbupdates.upd_minver DESC,
            upd_id
      LOOP
          -- v_match := 'false';
          elementID   := null;
          elementName := null;
          description := null;
          updquery    := null;
          upd_minver  := null;
          upd_txt     := null;
          parentupdid := null;

          IF  (
                -- Sql-statement durchsuchen
                    x.updquery ~* v_search_strings
                -- Beschreibung durchsuchen
                OR  x.upd_txt ~* v_search_strings
                -- Name durchsuchen
                OR  x.elementName ~* v_search_strings
              )
          THEN
              v_matches := null;
              updquery  := x.updquery;

              IF _p_case_insensitive IS TRUE THEN
                  updquery := lower( updquery );
              END IF;

              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( updquery, v_search_strings, 'g' ), ',' ) AS val ) AS y2
              ;

              matching_terms  := v_matches;
              elementID       := x.elementID;
              elementName     := coalesce( x.elementName, 'leer?!?' );
              description     := x.description;
              updquery        := x.updquery;
              upd_minver      := x.upd_minver;
              upd_txt         := x.upd_txt::varchar(8192);
              parentupdid     := x.parentupdid;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql SECURITY DEFINER;
--

--
-- DROP FUNCTION IF EXISTS TSystem.Search_RTF(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_RTF(
      _p_search_strings   text,
      _p_case_insensitive boolean,

      OUT elementID       varchar,
      OUT elementName     varchar,
      OUT description     varchar,
      OUT matching_terms  varchar,
      OUT sqlquery        text,
      OUT dfmDefinition   text,
      OUT changetext      text,
      OUT runtimeform     boolean
  ) RETURNS SETOF record AS $$
  DECLARE
      x                   record;
      v_matches           text;
      v_search_strings    text    := _p_search_strings;
      v_case_insensitive  boolean := coalesce(_p_case_insensitive, true);
  BEGIN

      IF _p_case_insensitive IS TRUE THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      FOR x IN
          SELECT
            rtf_id::varchar AS elementID,
            rtf_id::varchar || '.' || coalesce(rtf_table, '') || '.' ||coalesce( lang_text( rtf_txtnr ), '' ) AS elementName,
            rtf_id::varchar || '.' || coalesce(rtf_table, '') || '.' ||coalesce( lang_text( rtf_txtnr ), '' ) || '.' || ifthen( rtf_blanksql, 'ISBlankSQL', '' ) AS description,
            rtf_script      AS sqlquery,
            rtf_textdfm     AS dfmDefinition,
            rtf_changetext  AS changetext,
            rtf_runtimeform AS runtimeform
          FROM runtimeforms
          ORDER BY rtf_id
      LOOP
          IF  (
                -- Sql-statement durchsuchen
                    x.sqlquery ~* v_search_strings
                -- dfm durchsuchen
                OR  x.dfmDefinition ~* v_search_strings
                -- Änderungshinweise durchsuchen
                OR  x.changetext ~* v_search_strings
                -- elementID durchsuchen
                OR  x.elementID ~* v_search_strings
              )
          THEN
              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( sqlquery, v_search_strings ,'g' ), ',' ) AS val ) AS y2
              ;

              matching_terms  := v_matches;
              elementID       := x.elementID;
              elementName     := coalesce( x.elementName, 'leer?!?' );
              description     := x.description;
              sqlquery        := x.sqlquery;
              dfmDefinition   := x.dfmDefinition;
              changetext      := x.changetext;
              runtimeform     := x.runtimeform;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql;
--

-- Suche in Standard-SQLs
-- DROP FUNCTION IF EXISTS TSystem.Search_SystemSQL(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_SystemSQL(
      _p_search_strings     text,
      _p_case_insensitive   boolean,

      OUT elementID         varchar,
      OUT elementName       varchar,
      OUT description       varchar,
      OUT sqlStatement      text,
      OUT sql_modified      timestamp(0),
      OUT matching_terms    varchar
  ) RETURNS SETOF record AS $$
  DECLARE
      x                     record;
      v_matches             text;
      v_search_strings      text    := _p_search_strings;
      v_case_insensitive    boolean := _p_case_insensitive;
      v_sqlStatement        text;
  BEGIN
      -- v_search_strings is a list, pipe-separated, exactly what we want to search against.
      -- NOTE: works on postgresql v8.4
      -- Example: SELECT * FROM search_public_functions('crosstab|intersect|except|ctid',true);

      IF v_case_insensitive IS NOT FALSE THEN
          v_case_insensitive := true;
      END IF;

      IF _p_case_insensitive IS TRUE THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      FOR x IN
          SELECT
            sql_stamp::varchar AS elementID,
            sql_name::varchar  AS elementName,
            sql_descr::varchar AS description,
            sql_sql::varchar   AS sqlStatement,
            systemsqlstatement.sql_modified
          FROM systemsqlstatement
          WHERE NOT sql_deleted
          ORDER BY sql_name
      LOOP
          elementID     := null;
          elementName   := null;
          description   := null;
          sqlStatement  := null;

          IF  (
                -- Sql-statement durchsuchen
                    x.sqlStatement ~* v_search_strings
                -- Beschreibung durchsuchen
                OR  x.description ~* v_search_strings
              )
          THEN
              v_matches      := null;
              v_sqlStatement := x.sqlStatement;

              IF _p_case_insensitive IS TRUE THEN
                  v_sqlStatement := lower( v_sqlStatement );
              END IF;

              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( v_sqlStatement, v_search_strings, 'g'), ',' ) AS val ) AS y2
              ;

              elementID      := x.ElementID;
              elementName    := x.elementName;
              description    := x.description;
              matching_terms := v_matches;
              sqlStatement   := x.sqlStatement;
              sql_modified   := x.sql_modified;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql SECURITY DEFINER;
--

-- Suche im Prodat-Hauptmenü
-- DROP FUNCTION IF EXISTS TSystem.Search_MainMenu(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_MainMenu(
      _p_search_strings     text,
      _p_case_insensitive   boolean,

      OUT elementID         varchar,
      OUT elementName       varchar,
      OUT description       varchar,
      OUT sqlStatement      text,
      OUT mmconfig          text,
      OUT formclassname     varchar,
      OUT kunde             varchar,
      OUT rtfid             integer,
      OUT modified          timestamp(0),
      OUT matching_terms    varchar
  ) RETURNS SETOF RECORD AS $$
  DECLARE
        x                   record;
        v_matches           text;
        v_search_strings    text    := _p_search_strings;
        v_case_insensitive  boolean := _p_case_insensitive;
        v_sqlStatement      text;
  BEGIN
      IF v_case_insensitive IS NOT false THEN
          v_case_insensitive := true;
      END IF;

      IF _p_case_insensitive IS true THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      FOR x IN
          SELECT
            mm_id                   AS elementID,
            --mm_stamp::VARCHAR)  AS elementID,
            lang_text( mm_textno )  AS elementName,
            mm_sql                  AS sqlStatement,
            mm_config               AS mmconfig,
            mm_formclassname        AS formclassname,
            mm_kunde                AS kunde,
            mm_modified             AS modified,
            mm_description          AS description,
            mm_proc                 AS rtf_id
          FROM mainmenu
          WHERE lower( mm_sql ) iLIKE '%SELECT%' OR mm_config iLIKE '%.query%'
      LOOP
          elementID     := null;
          elementName   := null;
          sqlStatement  := null;
          mmconfig      := null;
          formclassname := null;
          kunde         := null;
          modified      := null;
          description   := null;
          rtfid         := null;

          IF  (
                -- Sql-statement durchsuchen
                    x.sqlStatement ~* v_search_strings
                -- config durchsuchen
                OR x.mmconfig ~* v_search_strings
                -- Beschreibung durchsuchen
                OR x.description ~* v_search_strings
                -- RTF
                OR x.rtf_id ~* v_search_strings
              )
          THEN
              v_matches      := null;
              v_sqlStatement := x.sqlStatement;

              IF _p_case_insensitive IS true THEN
                  v_sqlStatement := lower( v_sqlStatement );
              END IF;

              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( v_sqlStatement, v_search_strings, 'g' ), ',' ) AS val ) AS y2
              ;

              elementID       := x.ElementID;
              elementName     := x.elementName;
              description     := x.description;
              sqlStatement    := x.sqlStatement;
              mmconfig        := x.mmconfig;
              formclassname   := x.formclassname;
              kunde           := x.kunde;
              modified        := x.modified;
              matching_terms  := v_matches;
              rtfid           := x.rtf_id;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql SECURITY DEFINER;
--

-- Suche in Feld-Übersetzungen
-- DROP FUNCTION IF EXISTS TSystem.Search_FeldAlias(text, boolean);
CREATE OR REPLACE FUNCTION TSystem.Search_FeldAlias(
      _p_search_strings     text,
      _p_case_insensitive   boolean,

      OUT elementID         timestamp(0),
      OUT fafieldname       varchar,
      OUT tablename         varchar,
      OUT textno            integer,
      OUT textnolang        text,
      OUT linkmodules       text,
      OUT displayformat     varchar,
      OUT editformat        varchar,
      OUT constraints       varchar,
      OUT wawipos_map       varchar
  ) RETURNS SETOF record AS $$
  DECLARE
      x                     record;
      v_matches             text;
      v_search_strings      text    := _p_search_strings;
      v_case_insensitive    boolean := _p_case_insensitive;
      v_fafieldname         text;
  BEGIN
      IF v_case_insensitive IS NOT FALSE THEN
          v_case_insensitive := true;
      END IF;

      IF _p_case_insensitive IS TRUE THEN
          v_search_strings := lower( v_search_strings );
      END IF;

      FOR x IN
          SELECT
            fa_modified          AS elementID,
            fa_fieldname         AS fafieldname,
            fa_tablename         AS tablename,
            fa_textno            AS textno,
            lang_text(fa_textno) AS textnolang,
            fa_linkmodules       AS linkmodules,
            fa_displayformat     AS displayformat,
            fa_editformat        AS editformat,
            fa_constraints       AS constraints,
            fa_wawipos_map       AS wawipos_map
          FROM fieldalias
      LOOP
          elementID     := null;
          fafieldname   := null;
          tablename     := null;
          textno        := null;
          textnolang    := null;
          linkmodules   := null;
          displayformat := null;
          editformat    := null;
          constraints   := null;
          wawipos_map   := null;

          IF  (
                -- Feldname
                  x.fafieldname ~* v_search_strings
                -- Tabellenname
                OR x.tablename ~* v_search_strings
                -- TextNo
                OR x.textno ~* v_search_strings
              )
          THEN
              v_matches     := null;
              v_fafieldname := x.fafieldname;

              IF _p_case_insensitive IS TRUE THEN
                  v_fafieldname := lower( v_fafieldname );
              END IF;

              SELECT array_to_string( array_agg( val ), ',' )
              INTO v_matches
              FROM ( SELECT DISTINCT array_to_string( regexp_matches( v_fafieldname, v_search_strings, 'g' ), ',' ) AS val ) AS y2
              ;

              elementID     := x.ElementID;
              fafieldname   := x.fafieldname;
              tablename     := x.tablename;
              textno        := x.textno;
              textnolang    := x.textnolang;
              linkmodules   := x.linkmodules;
              displayformat := x.displayformat;
              editformat    := x.editformat;
              constraints   := x.constraints;
              wawipos_map   := x.wawipos_map;

              RETURN NEXT;

          END IF;

      END LOOP;

  END $$ LANGUAGE plpgsql SECURITY DEFINER;
--

-- Lücken suchen sollte wenn möglich immer über Nummernkreis-CheckSQL erfolgen. Hier nur (noch?!) vorhanden, weil in Mitarbeiternummern verwendet.
CREATE OR REPLACE FUNCTION Find_Gap(inTable VARCHAR, inIntField VARCHAR, inMin BIGINT) RETURNS BIGINT AS $$
 DECLARE min BIGINT;
    exist BOOLEAN;
    i BIGINT;
 BEGIN
  IF EXISTS (SELECT TRUE FROM information_schema.columns WHERE table_name=inTable AND column_name=inIntField AND (data_type='integer' OR data_type='smallint' OR data_type='bigint')) THEN
  min:=inMin;
  EXECUTE 'SELECT EXISTS(SELECT TRUE FROM ' || inTable || ' WHERE ' || inIntField || '>=' || inMin || ' ORDER BY ' || inIntField || ' ASC)' INTO exist;
  IF exist THEN

   FOR i IN EXECUTE 'SELECT ' || inIntField || ' FROM ' || inTable || ' WHERE ' || inIntField || '>=' || inMin || ' ORDER BY ' || inIntField || ' ASC' LOOP
    IF i>min THEN
     RETURN min;
    ELSE
     min:=min+1;
    END IF;
   END LOOP;
   RETURN min; --max+1

  ELSE
   RETURN min;
  END IF;

 END IF;
 RETURN NULL;
 END $$ LANGUAGE plpgsql STABLE;
--

-- Gibt ein ASCII-Art Bild zum Testen von Sonderzeichen in RTFs aus
CREATE OR REPLACE FUNCTION TSystem.Skull(OUT test TEXT, OUT test_rtf TEXT) RETURNS RECORD AS $$
 BEGIN
  test:='PRODAT-Grundkurs: Anatomie'||E'\r\n'||E'\r\n'||'              ___           _,.---,---.,_'||E'\r\n'||'              |         ,;~´             ,~;,_'||E'\r\n'||'              |       ,;                     ;,_'||E'\r\n'||'     Frontal  |      ;                         ; ,--- Supraorbital Foramen_'||E'\r\n'||'      Bone    |     ,;                         /;_'||E'\r\n'||'              |    ,;                        /; ;,_'||E'\r\n'||'              |    ; ;      .           . <-,  ; |_'||E'\r\n'||'              |__  | ;   ______       ______   ;<----- Coronal Suture_'||E'\r\n'||'             ___   |  |/~"     ~" . "~     "~\|  |_'||E'\r\n'||'             |     |  ~  ,-~~~^~, | ,~^~~~-,  ~  |_'||E'\r\n'||'   Maxilla,  |      |   |        }:{        | <------ Orbit_'||E'\r\n'||'  Nasal and  |      |   l       / | \       !   |_'||E'\r\n'||'  Zygomatic  |      .~  (__,.--" .^. "--.,__)  ~._'||E'\r\n'||'    Bones    |      |    ----;` / | \ `;-<--------- Infraorbital Foramen_'||E'\r\n'||'             |__     \__.       \/^\/       .__/_'||E'\r\n'||'                ___   V| \                 / |V <--- Mastoid Process_'||E'\r\n'||'                |      | |T~\___!___!___/~T| |_'||E'\r\n'||'                |      | |`IIII_I_I_I_IIII´| |_'||E'\r\n'||'       Mandible |      |  \,III I I I III,/  |_'||E'\r\n'||'                |       \   `~~~~~~~~~~´    /_'||E'\r\n'||'                |         \   .       . <-x---- Mental Foramen_'||E'\r\n'||'                |__         \.    ^    ./_'||E'\r\n'||'                              ^~~~^~~~^       -dcau (4/15/95)';
  test_rtf:='{\\rtf1\\ansi\\deff0{\\fonttbl{\\f0\\fnil\\fcharset0 Courier New;}}'||E'\r\n'||'\\viewkind4\\uc1\\pard\\lang1031\\f0\\fs20 PRODAT-Grundkurs: Anatomie\\par'||E'\r\n'||E'\r\n'||'               ___           _,.---,---.,_\\par'||E'\r\n'||'              |         ,;~´             ´~;,\\par'||E'\r\n'||'              |       ,;                     ;,\\par'||E'\r\n'||'     \\b Frontal  \\b0 |      ;                         ; ,--- \\b Supraorbital Foramen\\b0\\par'||E'\r\n'||'      \\b Bone    \\b0 |     ,´                         /´\\par'||E'\r\n'||'              |    ,;                        /´ ;,\\par'||E'\r\n'||'              |    ; ;      .           . <-´  ; |\\par'||E'\r\n'||'              |__  | ;   ______       ______   ;<----- \\b Coronal Suture\\par'||E'\r\n'||'\\b0              ___   |  ´/~"     ~" . "~     "~\\´  |\\par'||E'\r\n'||'             |     |  ~  ,-~~~^~, | ,~^~~~-,  ~  |\\par'||E'\r\n'||'   \\b Maxilla\\b0 ,  |      |   |        \\}:\\{        | <------ \\b Orbit\\b0\\par'||E'\r\n'||'  \\b Nasal and \\b0  |      |   l       / | \\\\       !   |\\par'||E'\r\n'||'  \\b Zygomatic\\b0   |      .~  (__,.--" .^. "--.,__)  ~.\\par'||E'\r\n'||'    \\b Bones    \\b0 |      |    ----;´ / | \\\\ `;-<--------- \\b Infraorbital Foramen\\par'||E'\r\n'||'\\b0              |__     \\\\__.       \\\\/^\\\\/       .__/\\par'||E'\r\n'||'                ___   V| \\\\                 / |V <--- \\b Mastoid Process\\par'||E'\r\n'||'\\b0                 |      | |T~\\\\___!___!___/~T| |\\par'||E'\r\n'||'                |      | |`IIII_I_I_I_IIII´| |\\par'||E'\r\n'||'       \\b Mandible \\b0 |      |  \\\\,III I I I III,/  |\\par'||E'\r\n'||'                |       \\\\   `~~~~~~~~~~´    /\\par'||E'\r\n'||'                |         \\\\   .       . <-x----\\b  Mental Foramen\\par'||E'\r\n'||'\\b0                 |__         \\\\.    ^    ./\\par'||E'\r\n'||'                              ^~~~^~~~^       \\ul\\i -dcau (4/15/95)\\par'||E'\r\n'||'}';
 RETURN;
 END $$ LANGUAGE plpgsql STABLE;
--

-- Schreibt einen Test-RTF Text in die angegebene Tabelle und Spalte
CREATE OR REPLACE FUNCTION TSystem.SetSkull(IN tablename VARCHAR, IN rtf_field VARCHAR, DBRID VARCHAR) RETURNS VOID AS $$
 BEGIN
  EXECUTE 'UPDATE '||tablename || ' SET ' || rtf_field || ' = (TSystem.Skull()).test,'|| rtf_field || '_rtf = (TSystem.Skull()).test_rtf WHERE dbrid = ' || dbrid;
 RETURN;
 END $$ LANGUAGE plpgsql VOLATILE;
--

-- Erstellt einen View zur Abfrage von DB-Tabellen, Views darauf, Feldern und ForeignKeys der Felder. Schließt PG_catalog und einige System-Schemata aus.
DROP VIEW IF EXISTS TSystem.tablefieldinfo_view;
CREATE VIEW TSystem.tablefieldinfo_view AS

  SELECT
    -- this filters out composite indicies and duplicated FKs on same columns
    DISTINCT ON ( n.nspname, c.relname, a.attnum )

    -- this function is used by the information schema views
    -- the bitmask works like this:
    --    b'00000100' = deleteable
    --    b'00001000' = updateable
    --    b'00010000' = insertable
    (pg_relation_is_updatable(c.oid::regclass, false)::bit(8) & b'00011100' = b'00011100' ) AS isWritable,

    c.relkind = 'v' AS isview,
    n.nspname       AS schemaname,
    c.relname       AS tablename,
    a.attnum        AS index,
    a.attname       AS field,

    -- t.typcategory,
    format_type( a.atttypid, null ) AS type,

    -- length only for string types
    CASE WHEN
        -- S = varchars und chars
        t.typcategory IN ( 'S' )
      THEN nullif(a.atttypmod,-1) - 4
      ELSE null
    END
    AS length,

    -- adsrc was removed in pg12
    pg_get_expr( d.adbin, d.adrelid ) AS "default",

    fn.nspname AS foreign_table_schema,
    ft.relname AS foreign_table_name,
    fc.attname AS foreign_column_name

  FROM
    pg_class                  AS c

    -- schemata
    LEFT JOIN pg_namespace    AS n ON
          n.oid = c.relnamespace

    -- columns
    LEFT JOIN pg_attribute    AS a ON
          c.oid = a.attrelid

    -- columntypes
    LEFT JOIN pg_type         AS t ON
          t.oid = a.atttypid

    -- default values of columns
    LEFT JOIN pg_attrdef      AS d ON
          d.adrelid = c.oid
      AND d.adnum = a.attnum

    -- FKs
    LEFT JOIN pg_constraint   AS f ON
          f.contype = 'f'             -- foreignkey
      AND f.conrelid = c.oid          -- local table
      AND array_length ( f.confkey , 1 ) < 2 -- exclude composite keys
      AND f.conkey[1] = a.attnum      -- conkey is a array over the attributes ordinal positions

    -- destination of FKs
    LEFT JOIN pg_attribute    AS fc ON
          f.confrelid  = fc.attrelid -- foreign table
      AND f.confkey[1] = fc.attnum

    LEFT JOIN pg_class        AS ft ON
          ft.oid = f.confrelid

    LEFT JOIN pg_namespace    AS fn ON
          fn.oid = ft.relnamespace

  WHERE
    -- only tables and views ( including materialized views )
        c.relkind IN ('r','v','m')

    -- p = permanent table ( default tables)
    -- u = unlogged table ( eg. tlog.auditlog )
    -- t = temporary table ( pg_temp_%, create temp table )
    AND c.relpersistence IN ('p','u')

    -- exclude certain namespaces; they are lowercase by default, except for doubleQuoted Identifier
    -- ACHTUNG: analog FUNCTION TSystem.tables__fieldInfo__fetch
    AND lower(n.nspname) NOT IN ('pg_catalog', 'information_schema', 'tcache'/*'tlog'=>auditlog special abgefangen siehe oben*/, 'scheduling', 'z_99_drop', 'x_950_import', 'x_900_export', 'z_50_customer__eabk'/*!!*/ /*!customer %?! => hätten lokale tables nie dbrid*/) --

    -- hide internal fields
    -- # select attname, attnum from pg_attribute where attrelid = 'abk'::regclass::oid and attnum < 3
    -- ┌──────────────┬────────┐
    -- │   attname    │ attnum │
    -- ╞══════════════╪════════╡
    -- │ tableoid     │     -7 │
    -- │ cmax         │     -6 │
    -- │ xmax         │     -5 │
    -- │ cmin         │     -4 │
    -- │ xmin         │     -3 │
    -- │ ctid         │     -1 │
    -- │ ab_ix        │      1 │
    -- │ ab_parentabk │      2 │
    -- └──────────────┴────────┘
    AND a.attnum > 0

    -- we must omit dropped columns
    AND a.attisdropped IS false


  ORDER BY schemaname, tablename, index
;
--

-- Ausgelagert aus Delphi. Ergänzt um Weitergabe der Constraints zugrundeliegender Tabelle an die Views.
CREATE OR REPLACE FUNCTION TSystem.tablefieldinfo__recreate(OUT fieldCountBefore INTEGER, OUT fieldCountAfter INTEGER) RETURNS RECORD AS $$
  BEGIN

    FieldCountBefore := COUNT(*) FROM tablefieldinfo;

    -- Einfach alles rauswerfen und neu aufbauen aus den Information-Schema Katalogen.
    TRUNCATE tablefieldinfo;

    INSERT INTO tablefieldinfo ( isWritable, isView, schemaname, tablename, index, field, type, length, def, foreign_schema, foreign_table, foreign_column)
    SELECT * FROM TSystem.TableFieldInfo_view ORDER BY schemaname, tablename, field;

    -- View ist Updatable und wird als ChildLink benutzt. Also brauchen wir Defaults und Foreign-Keys.
    PERFORM TSystem.CopyConstraintInfo('public', 'oplpm_data', 'public', 'oplpm');
    PERFORM TSystem.CopyConstraintInfo('public', 'oplpm_stam', 'public', 'oplpm_data');

    -- view dbrid default wert setzen
    UPDATE tablefieldinfo SET def = 'nextval(''db_id_seq'')' WHERE isView AND isWritable AND field = 'dbrid';

    FieldCountAfter :=  COUNT(*) FROM tablefieldinfo;

    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--

CREATE OR REPLACE FUNCTION TSystem.CopyConstraintInfo( srcSchema VARCHAR,  srcTable VARCHAR,  trgSchema VARCHAR,  trgViewOrTableName VARCHAR) RETURNS VOID AS $$
  BEGIN

    -- kopiert spalten defaultwert von tabellen in view informationen
    UPDATE tablefieldinfo AS trg SET
        def            = CASE WHEN trg.isWritable THEN src.def ELSE NULL END,
        foreign_table  = src.foreign_table,
        foreign_column = src.foreign_column
      FROM tablefieldinfo AS src
      WHERE trg.schemaname = trgSchema
        AND trg.tablename  = trgViewOrTableName
        AND src.Field      = trg.field
        AND src.schemaname = srcSchema
        AND src.tablename  = srcTable;
    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--

-- Löschen aller doppelten ForeignKeys
CREATE OR REPLACE FUNCTION TSystem.drop_fk_clones() RETURNS VOID AS $$
DECLARE
    r RECORD;
 BEGIN
    FOR r in (SELECT
                  tc0.table_name AS tablename
                , tc0.constraint_name AS key
              FROM information_schema.table_constraints AS tc0
              JOIN information_schema.table_constraints AS tc1 ON tc0.constraint_name LIKE tc1.constraint_name||'_%'
              WHERE tc1.constraint_name NOT LIKE 'xtt%'
              AND tc1.constraint_type = 'FOREIGN KEY'
              ORDER by tc1.table_name, tc1.constraint_name)
    LOOP
       EXECUTE 'ALTER TABLE '||r.tablename||' DROP CONSTRAINT IF EXISTS '||r.key;
    END LOOP;
    RETURN;
 END $$ LANGUAGE plpgsql VOLATILE;
--

-- Vergleichsfunktionen (VARCHAR, NUMERIC, INTEGER, TIMESTAMP, BOOLEAN)
    CREATE OR REPLACE FUNCTION TSystem.Equals(string1 VARCHAR, string2 VARCHAR) RETURNS BOOL AS $$
        SELECT string1 IS NOT DISTINCT FROM string2
      $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION TSystem.Equals(num1 NUMERIC, num2 NUMERIC) RETURNS BOOL AS $$
        SELECT num1 IS NOT DISTINCT FROM num2
      $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION TSystem.Equals(int1 INTEGER, int2 INTEGER) RETURNS BOOL AS $$
        SELECT int1 IS NOT DISTINCT FROM int2
      $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION TSystem.Equals(dat1 TIMESTAMP, dat2 TIMESTAMP) RETURNS BOOL AS $$
        SELECT dat1 IS NOT DISTINCT FROM dat2
      $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;

    CREATE OR REPLACE FUNCTION TSystem.Equals(bol1 BOOLEAN, bol2 BOOLEAN) RETURNS BOOL AS $$
        SELECT bol1 IS NOT DISTINCT FROM bol2
      $$ LANGUAGE sql IMMUTABLE PARALLEL SAFE;
--

-- Formatiert einen String, indem für jedes % Zeichen ein VARCHAR Parameter eingefügt wird => TSystem.FormatS('Das % kommt im Alphabet vor %!' ,'A','B');
CREATE OR REPLACE FUNCTION TSystem.FormatS( INOUT str VARCHAR, VARIADIC params VARCHAR[] DEFAULT NULL) RETURNS VARCHAR AS $$
 DECLARE idx      INTEGER;
         parLength  INTEGER;
 BEGIN

   IF params IS NULL THEN RETURN; END IF;

   idx:=0;
   parLength := ARRAY_LENGTH(params,1);

   WHILE (Position('%' IN str) > 0 ) AND (idx<=parLength) LOOP
     idx:=idx+1;
     IF (idx <= parLength) THEN
        str := RegExp_Replace(str, '%', COALESCE(params[idx],''));
     END IF;
   END LOOP;

   RETURN;
 END $$ LANGUAGE plpgsql VOLATILE;

 /* Beispiele:
     -- SELECT TSystem.FormatS('Ein % gefolgt von einem % und einem %. D und E werden ignoriert.' ,'A','B','C','D','E');
     -- Ausgabe: "Ein A gefolgt von einem B und einem C. D und E werden ignoriert."

     -- SELECT TSystem.FormatS('Ein % gefolgt von einem % und einem %. Am Ende ein paar Prozentzeichen ohne Werte % % % %','A','B','C');
     -- Ausgabe: "Ein A gefolgt von einem B und einem C. Am Ende ein paar Prozentzeichen ohne Werte % % % % weil nicht genügend Parameter angegeben sind."

     -- SELECT TSystem.FormatS('Heute ist der % und ich bin %. ' , Today()::VARCHAR, current_user::VARCHAR);
     -- Ausgabe: "Heute ist der 2014-04-15 und ich bin postgres."
  */
--

-- Konkateniert alle Nicht-NULL Werte aus Lines und fügt dazwischen Zeilenumbrüche ein. Beispiele siehe unten.
CREATE OR REPLACE FUNCTION TSystem.FormatLines( VARIADIC lines VARCHAR[] DEFAULT NULL, OUT str VARCHAR) RETURNS VARCHAR AS $$
 --DECLARE idx      INTEGER;
 --        parLength  INTEGER;
 BEGIN
  /*
  IF lines IS NULL THEN RETURN; END IF;

  idx:=0;
  parLength := ARRAY_LENGTH(lines,1);

  FOR idx IN 1..parLength LOOP
    -- RAISE NOTICE '%',lines[idx];
    IF (lines[idx] IS NOT NULL) THEN
      IF Str IS NOT NULL THEN
        str:=str || E'\r\n' || lines[idx];
      ELSE
        str:=lines[idx];
      END IF;
    END IF;
  END LOOP;

   RETURN;
   */
   str := array_to_string(lines, E'\r\n');
   RETURN;
 END $$ LANGUAGE plpgsql VOLATILE;

  /* Beispiel:
     SELECT FormatLines('Zeile1', 'Zeile2', 'Zeile3', 'Zeile4');

     SELECT concat_ws('\r\n', 'Zeile1', 'Zeile2', 'Zeile3', 'Zeile4');

     Ausgabe:
       Zeile1
       Zeile2
       Zeile3
       Zeile4


     SELECT FormatS(
          FormatLines(
            'Artikelnummer=%',
            'Bezeichnung=%',
            'AC=%'),
          ak_nr, ak_bez, ak_ac)
      FROM art WHERE ak_nr LIKE 'ART%';

     SELECT concat('Artikelnummer=', ak_nr, '\r\nBezeichnung=', ak_bez, '\r\nAC=', ak_ac)
     FROM art WHERE ak_nr LIKE 'ART%';

      Ausgabe für jeden Artikel:
        Artikelnummer=ART-INV1
        Bezeichnung=Artikel INV1
        AC=WE1001
  */
--

-- INI-TEXT, StringList-TEXT (Name=Value) und ENUM in der DB behandeln (Schema: TSystem)
  -- Gleichnamige Funktionen teilweise auch in PRODAT vorhanden. -> UCimRtl.StrUtils.pas

  -- line  = SL_GetLine (list,          index)                     Zeile aus einem StringList-TEXT auslesen
  -- value = SL_GetValue(list,          name,        [defvalue])   Value aus einem StringList-TEXT auslesen -> Name=Value
  -- list  = SL_SetValue(list,          name, value, [defvalue])   Value in  einem StringList-TEXT ändern   -> Name=Value
  -- value = INI_GetValue(ini, section, name,        [defvalue])   Value aus einem INI-TEXT auslesen -> [Section] Name=Value
  -- ini   = INI_SetValue(ini, section, name, value, [defvalue])   Value in  einem INI-TEXT ändern   -> [Section] Name=Value
  -- list  = ENUM_SetValue(list, value)                            Value in  kommaseparierte  Liste einfügen
  -- bool  = ENUM_GetValue(list, value)                            Value in  kommaseparierter Liste suchen
  -- list  = ENUM_DelValue(list, value)                            Value aus kommaseparierter Liste entfernen

  -- Initial  : SELECT TSystem.Settings__Set('Test', 'aaa=nee\r\nbbb=ok\r\nccc=nee'), TSystem.Settings__Set('Test2', '[zzz]\r\nbbb=nee\r\n[xxx]\r\naaa=nee\r\nbbb=ok\r\nccc=nee')
  -- SL-Test1 : SELECT TSystem.Settings__GetText('Test'), SL_GetValue(TSystem.Settings__Get('Test'), 'bbb'), SL_SetValue(TSystem.Settings__Get('Test'), 'bbb', 'NEU'), SL_SetValue(TSystem.Settings__Get('Test'), 'bbc', 'NEU')
  -- SL-Test2 : SELECT TSystem.Settings__GetText('Test'), SL_GetLine(TSystem.Settings__Get('Test'), 1), SL_GetLine(TSystem.Settings__Get('Test'), 3), SL_GetLine(TSystem.Settings__Get('Test'), 4)
  -- INI-Test : SELECT TSystem.Settings__GetText('Test2'), INI_GetValue(TSystem.Settings__Get('Test2'), 'xxx', 'bbb'), INI_SetValue(TSystem.Settings__Get('Test2'), 'xxx', 'bbb', 'NEU'), INI_SetValue(TSystem.Settings__Get('Test2'), 'xxx', 'bbc', 'NEU')

  -- Zeile aus einem StringList-TEXT auslesen
  CREATE OR REPLACE FUNCTION TSystem.SL_GetLine(list TEXT, line INTEGER) RETURNS VARCHAR AS $$
    --SELECT (regexp_matches(list, '^(.*)$', 'm'))[line]

    -- Aus unerfindlichen Gründen funktioniert das Zeilenendematching nicht mehr, daher manuell die Zeilenumbrüche suchen http://www.delphipraxis.net/189708-regex-fehlerhafter-zeilenumbruch-postgresql.html
    SELECT (regexp_split_to_array(list, E'\\r?\\n'))[line]
   $$ LANGUAGE SQL IMMUTABLE;
  --

  -- Value aus einem StringList-TEXT auslesen -> Name=Value (ebenfalls in UCimRtl.StrUtils.pas)
  CREATE OR REPLACE FUNCTION TSystem.SL_GetValue(list TEXT, name VARCHAR, defvalue VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
    -- regexp_matches liefert "keinen" Datensatz, wenn nichts gefunden wurde, daher das SUBSELECT mit COALESCE
    SELECT coalesce(nullif((SELECT (regexp_matches(list, '^' || name || '=(.*)$', 'mi'))[1]), ''), defvalue)
   $$ LANGUAGE SQL IMMUTABLE;
  --

  -- Value in einem StringList-TEXT ändern -> Name=Value (ebenfalls in UCimRtl.StrUtils.pas)
  CREATE OR REPLACE FUNCTION TSystem.SL_SetValue(list TEXT, name VARCHAR, value VARCHAR, defvalue VARCHAR DEFAULT NULL) RETURNS TEXT AS $$
    BEGIN
      -- altes weg
      list := regexp_replace(list, '^' || name || '=(.*)$', '', 'mi');
      -- neues rein
      IF (coalesce(value, '') <> '') AND (coalesce(value, '') <> coalesce(defvalue, '')) THEN
        list := concat(list, E'\r\n', name, '=', value);
      END IF;
      -- sortieren
      RETURN trim(array_to_string(ARRAY(SELECT regexp_split_to_table(list, E'\r?\n' , 'mi') ORDER BY 1), E'\r\n'), E' \r\n');
    END $$ LANGUAGE plpgsql;
  --

  -- Value aus einem INI-TEXT auslesen -> [Section] Name=Value
  CREATE OR REPLACE FUNCTION TSystem.INI_GetValue(ini TEXT, section VARCHAR, name VARCHAR, defvalue VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
    DECLARE
      sectionsinhalt TEXT;
      val VARCHAR;
    BEGIN
      --Inhalt der eingegebenen 'section' ablesen oder 'defvalue' nehmen, wenn nicht gefunden
      SELECT trim(substring(ini FROM E'\\[' || section || E'\\]([^\\[]*)'), E'\r\n\t ') INTO sectionsinhalt;
      IF sectionsinhalt IS NULL THEN
        RETURN defvalue;
      END IF;

      --Value mit dem 'name' aus der 'section' ablesen oder 'defvalue' nehmen, wenn nicht gefunden
      SELECT COALESCE(trim(substring(sectionsinhalt FROM E'[$\r\n]*' || name || E'[ \t]*=[ \t]*([^\r\n$]*)'), E'\r\n\t '), defvalue) INTO val;

      RETURN val;
    END $$ LANGUAGE plpgsql IMMUTABLE;
  --

  -- Value in einem INI-TEXT ändern -> [Section] Name=Value
  -- Erstellt eine neue Sektion wenn die nicht existiert
  CREATE OR REPLACE FUNCTION TSystem.INI_SetValue(ini TEXT, section VARCHAR, name VARCHAR, value VARCHAR) RETURNS TEXT AS $$
    DECLARE
      val VARCHAR;
      line VARCHAR;
      sectionsinhalt_alt TEXT;
      sectionsinhalt_neu TEXT;
    BEGIN
      ini := trim(ini, E'\r\n\t ');
      SELECT TSystem.INI_GetValue(ini, section, name) INTO val;
      IF val IS NULL THEN
        --[einfügen]--

        --Inhalt der eingegebenen 'section' mit Sektionbezeichnung ablesen
        SELECT trim(substring(ini FROM E'(\\[' || section || E'\\][^\\[]*)'), E'\r\n\t ') INTO sectionsinhalt_alt;

        --wenn die 'section' nicht existiert
        IF not(nullif(sectionsinhalt_alt, '') IS DISTINCT FROM NULL) THEN
          IF nullif(ini, '') IS DISTINCT FROM NULL THEN
            sectionsinhalt_neu := E'\r\n';
          ELSE
            --wenn komplett leer war, Zeilenumbruch am Anfang der INI ausschließen
            sectionsinhalt_neu := '';
          END IF;
          --erstellen und am Ende der Sektion einfügen
          sectionsinhalt_neu := concat(sectionsinhalt_neu, '[', section, ']', E'\r\n', name, ' = ', value);
          ini := concat(ini, sectionsinhalt_neu);
        ELSE
          --komplete Sektion umschreiben
          sectionsinhalt_neu := concat(sectionsinhalt_alt, E'\r\n', name, ' = ', value);
          ini := replace(ini, sectionsinhalt_alt, sectionsinhalt_neu);
        END IF;
        RETURN ini;
      ELSE
        --[ersetzen]--

        --Inhalt der eingegebenen 'section' mit Sektionbezeichnung ablesen
        SELECT trim(substring(ini FROM E'(\\[' || section || E'\\][^\\[]*)'), E'\r\n\t ') INTO sectionsinhalt_alt;
        --komplete Zeile finden
        SELECT substring(sectionsinhalt_alt FROM E'[$\r\n]*([\t ]*' || name || E'[ \t]*=[ \t]*([^\r\n$]*))') INTO line;
        --komplete Zeile esetzen
        sectionsinhalt_neu := replace(sectionsinhalt_alt, line, concat(name, ' = ', value));
        --komplete Sektion umschreiben
        ini := replace(ini, sectionsinhalt_alt, sectionsinhalt_neu);
        RETURN ini;
      END IF;
    END $$ LANGUAGE plpgsql;
  --
  -- https://github.com/prodat/psql/pull/359
  -- Gibt für ein Ini-File formatierten Text Section/Key/Pair zurück
  -- Achtung, noch nie im Einsatz. Beachte Tests im CI
  CREATE OR REPLACE FUNCTION TSystem.INI_GetNames(
      IN  _ini text,
      IN  _section text
      ) RETURNS SETOF text AS $$
      DECLARE
        _regex text :=
            $regex$
              \[%s\]      # section
              (.*?)          # content of the section, nongreedy
              (?=            # matches up until the next [section] or fileend
                  [^#]       # ingores section if commented out
                  \[.+\]     # section
                | $          # fileend
              )
            $regex$;

        _regex_flags text := 'igsx';
        _section_data text;

      BEGIN

        -- build regex
        _regex := format( _regex, _section );

        -- strip out windows lineendings
        _ini := replace( _ini, E'\\r', '' );

        -- fetch section data
        _section_data := (regexp_matches( _ini, _regex, _regex_flags ))[1];

        RETURN QUERY
          WITH
            _rows as (
                SELECT row
                FROM regexp_split_to_table(
                         _section_data,
                         E'\\n'
                     ) t(row)
                WHERE trim( row ) <> '' -- filter out empty frows
            ),

            _keys AS (
              SELECT (regexp_split_to_array( row, '=' ))[1] as key
              FROM _rows
            )

            SELECT key
            FROM _keys
            WHERE key !~ '#' -- filter out comments
        ;

      END $$ LANGUAGE plpgsql IMMUTABLE;


-- ENUM
  -- Liste als Array ausgeben
  SELECT tsystem.function__drop_by_regex('ENUM_list_to_array', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_list_to_array(
    IN  _list      text,
    IN  _delimiter varchar = ','
    ) RETURNS text[]
    AS $$

      SELECT string_to_array( coalesce( _list, '' ), _delimiter );

    $$ LANGUAGE sql IMMUTABLE;
  --
  -- Value aus kommaseparierter Liste entfernen / TestCase= https://redmine.prodat-sql.de/issues/9377#note-10
  SELECT tsystem.function__drop_by_regex('ENUM_DelValue', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_DelValue(
      IN _list text,
      IN _value varchar -- Liste! (komma separiert)
      )
      RETURNS varchar
      AS $$
        SELECT nullif(
          CASE
            WHEN nullif( _value, '' ) IS NULL THEN nullif( _list, '' )
            ELSE array_to_string(
              ARRAY(
                SELECT elem
                  FROM unnest( TSystem.ENUM_list_to_array( _list ) )
                       WITH ORDINALITY AS t( elem, ord )                     -- ursprüngliche Sortierung der Werte soll beibehalten werden
                 WHERE elem <> ALL( TSystem.ENUM_list_to_array( _value ) )
                 ORDER BY ord
              ),
              ','
            )
          END,
          ''
        );
      $$ LANGUAGE SQL IMMUTABLE;
  --
  -- Value in kommaseparierter Liste suchen / TestCase= https://redmine.prodat-sql.de/issues/9377#note-10
  SELECT tsystem.function__drop_by_regex('ENUM_GetValue__list__equals__values', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_GetValue__list__equals__values(
      IN _list text,
      IN _value varchar, -- List!
      IN _delimiter varchar = ','
      )
      RETURNS bool
      AS $$
        -- Alle Elemente müssen im jeweils anderen enthalten sein. Reihenfolge egal. Listen haben somit gleichen Inhalt
        -- @= gibts nicht!
        SELECT      TSystem.ENUM_list_to_array( _value, _delimiter ) @> TSystem.ENUM_list_to_array( _list, _delimiter )
               AND  TSystem.ENUM_list_to_array( _value, _delimiter ) <@ TSystem.ENUM_list_to_array( _list, _delimiter )
      $$ LANGUAGE SQL IMMUTABLE;

  SELECT tsystem.function__drop_by_regex('ENUM_GetValue__list__contains_all__values', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_GetValue__list__contains_all__values(
      IN _list text,
      IN _value varchar, -- List!
      IN _delimiter varchar = ','
      )
      RETURNS bool
      AS $$
        -- Alle Elemente value müssen list sein. Reihenfolge egal. List kann mehr elemente als Value enthalten
        SELECT TSystem.ENUM_list_to_array( _value, _delimiter ) @> TSystem.ENUM_list_to_array( _list, _delimiter )
      $$ LANGUAGE SQL IMMUTABLE;

  SELECT tsystem.function__drop_by_regex('ENUM_GetValue', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_GetValue( -- >>ENUM_list_to_array both sides<< = ENUM_ContainsValue
      IN _list text,
      IN _value varchar, -- List!
      IN _delimiter varchar = ','
      )
      RETURNS bool
      AS $$
        -- Ein Element der Elementliste _value muss in _list enthalten sein. War bis 20.08.2023 SELECT _value = ANY( TSystem.ENUM_list_to_array( _list, _delimiter ) ). Somit war aber Reihenfolge usw. entscheidend. Ein mit komma reingegebener Value wurde auch nie gefunden.
        SELECT TSystem.ENUM_list_to_array( _value, _delimiter ) && TSystem.ENUM_list_to_array( _list, _delimiter )
      $$ LANGUAGE SQL IMMUTABLE;

  CREATE OR REPLACE FUNCTION TSystem.ENUM_GetValue__cascade_save( -- >>ENUM_list_to_array both sides<< = ENUM_ContainsValue
      IN _list text,
      IN _value varchar, -- List!
      IN _delimiter varchar = ','
      )
      RETURNS bool
      AS $$

        SELECT TSystem.ENUM_GetValue( _list, _value, _delimiter);

      $$ LANGUAGE SQL;


  SELECT tsystem.function__drop_by_regex('ENUM_HasValue', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_HasValue(
      IN _list text,
      IN _value varchar,  -- List!
      IN _delimiter varchar = ','
      )
      RETURNS bool
      AS $$
        SELECT TSystem.ENUM_GetValue( _list, _value, _delimiter )
      $$ LANGUAGE SQL IMMUTABLE;

  SELECT tsystem.function__drop_by_regex('ENUM_ContainsValue', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_ContainsValue( -- = ENUM_GetValue
      IN _list text,
      IN _value varchar,  -- List!: https://ci.prodat-sql.de/sources/tests/suite/4/runner/4#teststep-18868
      IN _delimiter varchar = ','
      )
      RETURNS bool
      AS $$
        SELECT TSystem.ENUM_GetValue( _list, _value, _delimiter )
      $$ LANGUAGE SQL IMMUTABLE;
  --

  -- Value in kommaseparierte Liste einfügen / TestCase= https://redmine.prodat-sql.de/issues/9377#note-10
  SELECT tsystem.function__drop_by_regex('ENUM_SetValue', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_SetValue(
      IN _list text,
      IN _value varchar
         -- für die übergabe mehrerer Werte mit einmal zu setzen
      --,IN _value_allows_comma__multi_values bool = false
      )
      RETURNS varchar
      AS $$
      -- DECLARE e varchar;
      BEGIN

        /*
        -- Es gibt sehr viele Stellen, wo 2 Parameter mit einmal übergeben werden, daher hier diese Prüfung nicht.
        -- zB: durch Twawi.epreis__fixierter_lieferant__check, im Bestellvorschlag usw.

        IF     not   _value_allows_comma__multi_values
           and     ( _value ~ '[,]+' )
        THEN
           e := TSystem.FormatS('value must not contain commas: list="%", values="%".' || E'\r\n' || 'if you want to add more than one enum, set in_paremeter "_value_allows_comma__multi_values" to true', _list, _value);
           RAISE EXCEPTION '%', e;
        END IF;
        */

        IF nullif(_value, '') IS NULL THEN
           RETURN nullif(_list, '');
        END IF;

        RETURN array_to_string(
                    array(SELECT DISTINCT *
                            FROM unnest(
                                    array_append(TSystem.ENUM_list_to_array( _list ),
                                                 _value::text
                                                 )
                                 )
                           ORDER BY 1
                          )
                          ,
                          ','
               );

      END $$ LANGUAGE plpgsql IMMUTABLE;
  --

  -- kommaseparierte Liste aus kommaseparierter Liste entfernen
  SELECT tsystem.function__drop_by_regex('ENUM_DelValues__list__exclude__values', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_DelValues__list__exclude__values(
      IN _list text,
      IN _values text  --List!
      )
      RETURNS varchar AS $$
      DECLARE
        arr_list varchar[];
        var varchar;
      BEGIN
        arr_list := TSystem.ENUM_list_to_array(_list);
        FOREACH var IN ARRAY TSystem.ENUM_list_to_array(_values) LOOP
          arr_list := array_remove(arr_list, var);
        END LOOP;

        RETURN nullif(array_to_string(arr_list, ','), '');
      END $$ LANGUAGE plpgsql IMMUTABLE;
  --

  -- Value in kommaseparierter Liste umschalten (entfernen/hinzufügen) / TestCase= https://redmine.prodat-sql.de/issues/9377#note-10
  SELECT tsystem.function__drop_by_regex('ENUM_FlipValue', _cascade => true, _commit => true);
  CREATE OR REPLACE FUNCTION TSystem.ENUM_FlipValue(
      IN _list text,
      IN _value varchar
      )
      RETURNS varchar
      AS $$
      BEGIN
          IF TSystem.ENUM_GetValue(_list, _value) THEN
             RETURN TSystem.ENUM_DelValue(_list, _value);
          ELSE
             RETURN TSystem.ENUM_SetValue(_list, _value);
          END IF;
      END $$ LANGUAGE plpgsql IMMUTABLE;
  --
--

-- Datenbank-Informationen
  -- Informationen zu Datenbankobjekt "DefinitionsTabelle und Name/Definition"  (Tabelle nicht bekannt)
  CREATE OR REPLACE FUNCTION TSystem.postgres__get_object_info(objid OID) RETURNS VARCHAR AS $$
    DECLARE classid OID;
    BEGIN
      SELECT pg_class.oid INTO classid
        FROM pg_tables
        LEFT JOIN pg_namespace ON pg_namespace.nspname = pg_tables.schemaname
        LEFT JOIN pg_class ON relnamespace = pg_namespace.oid AND relname = tablename
        WHERE ConditionalExecuteNumeric(True, concat('SELECT 1 FROM ', schemaname, '.', tablename, ' WHERE oid = ', objid), True) = 1;
      RETURN TSystem.postgres__get_object_info(classid, objid);
    END $$ LANGUAGE plpgsql STABLE;
  --

  -- Informationen zu Datenbankobjekt "DefinitionsTabelle und Name/Definition"  (Tabelle bekannt)
  -- z.B. zum Anzeigen in menschenlesbarer Form für TSystem.postgres__get_dependency
  CREATE OR REPLACE FUNCTION TSystem.postgres__get_object_info(classid OID, objid OID) RETURNS VARCHAR AS $$
    BEGIN
      RETURN CASE classid
      --WHEN 'pg_amop'::regclass THEN
        WHEN 'pg_amproc'::regclass THEN concat('AMO-PROC ', (SELECT concat(amproc, ' (', opfname, ')') FROM pg_amproc LEFT JOIN pg_opfamily ON pg_opfamily.oid = amprocfamily WHERE pg_amproc.oid = objid))
        WHEN 'pg_attrdef'::regclass THEN concat('DEFAULT ', (SELECT pg_get_expr(d.adbin, d.adrelid) FROM pg_attrdef WHERE pg_attrdef.oid = objid))
        WHEN 'pg_cast'::regclass THEN concat('CAST ', (SELECT concat(format_type(castsource, NULL), ' >> ', format_type(casttarget, NULL), '  (', castfunc::regproc::VARCHAR, ')') FROM pg_cast WHERE pg_cast.oid = objid))
        WHEN 'pg_class'::regclass THEN concat('CLASS ', objid::regclass::VARCHAR)
      --WHEN 'pg_collation'::regclass THEN
        WHEN 'pg_constraint'::regclass THEN concat('CONSTRAINT ', pg_get_constraintdef(objid, True))
      --WHEN 'pg_conversion'::regclass THEN
      --WHEN 'pg_default_acl'::regclass THEN
        WHEN 'pg_extension'::regclass THEN concat('EXTENSION ', (SELECT concat(extname, ' ', extversion) FROM pg_extension WHERE pg_extension.oid = objid))
        WHEN 'pg_language'::regclass THEN concat('LANGUAGE ', (SELECT lanname FROM pg_language WHERE pg_language.oid = objid))
        WHEN 'pg_namespace'::regclass THEN concat('NAMESPACE ', (SELECT nspname FROM pg_namespace WHERE pg_namespace.oid = objid))
      --WHEN 'pg_opclass'::regclass THEN
        WHEN 'pg_operator'::regclass THEN concat('OPERATOR ', objid::regoperator::VARCHAR)
      --WHEN 'pg_opfamily'::regclass THEN
        WHEN 'pg_proc'::regclass THEN concat('FUNCTION ', objid::regprocedure::VARCHAR) --pg_get_function_arguments(objid)
        WHEN 'pg_rewrite'::regclass THEN concat('REWRITE RULE ', (SELECT concat('ON ', (ARRAY['SELECT', 'UPDATE', 'INSERT', 'DELETE'])[ev_type::INT-48], ' : ', rulename) FROM pg_rewrite WHERE pg_rewrite.oid = objid))
        WHEN 'pg_trigger'::regclass THEN concat('TRIGGER ', (SELECT tgname FROM pg_trigger WHERE pg_trigger.oid = objid)) --pg_get_triggerdef(objid, True))
      --WHEN 'pg_ts_config'::regclass THEN
      --WHEN 'pg_ts_dict'::regclass THEN
      --WHEN 'pg_ts_parser'::regclass THEN
      --WHEN 'pg_ts_template'::regclass THEN
        WHEN 'pg_type'::regclass THEN concat('TYPE ', objid::regtype::VARCHAR)
      --pg_get_indexdef(objid, 0, True)
      --pg_get_ruledef(rule_oid, pretty_bool)
      --pg_get_userbyid(role_oid)
      --pg_get_viewdef(view_oid, pretty_bool)
        ELSE concat(classid::regclass::VARCHAR, ' ', ifthen(IsNumeric(objid::VARCHAR), 'oid ', ''), objid::VARCHAR)
      END;
    END $$ LANGUAGE plpgsql STABLE;
  --

  -- Abhängigkeiten auflisten
  -- z.B. für F4 "Tabellen" im SQL-Ausführen
  CREATE OR REPLACE FUNCTION TSystem.postgres__get_dependency(IN _oid OID, OUT direction VARCHAR,
      OUT tablename VARCHAR, OUT tabledesc VARCHAR, OUT relation VARCHAR, OUT issystem BOOLEAN) RETURNS SETOF RECORD AS $$
    DECLARE rec RECORD;
            pos INTEGER;
    BEGIN
      FOR rec IN (
        SELECT DISTINCT classid, postgres__get_object_info(classid, objid) AS relation
        FROM pg_depend WHERE refobjid = _oid ORDER BY 2
      ) LOOP
        pos       := position(' ' IN rec.relation);
        direction := 'Dependency';
        tablename := rec.classid::regclass::VARCHAR;
        tabledesc := substring(rec.relation FROM 1 FOR pos - 1);
        relation  := substring(rec.relation FROM pos + 1);
        issystem  := rec.classid::regclass IN ('pg_language'::regclass, 'pg_namespace'::regclass);
        RETURN NEXT;
      END LOOP;
      FOR rec IN (
        SELECT DISTINCT refclassid, postgres__get_object_info(refclassid, refobjid) AS relation
        FROM pg_depend WHERE objid = _oid ORDER BY 2
      ) LOOP
        pos       := position(' ' IN rec.relation);
        direction := 'Required';
        tablename := rec.refclassid::regclass::VARCHAR;
        tabledesc := substring(rec.relation FROM 1 FOR pos - 1);
        relation  := substring(rec.relation FROM pos + 1);
        issystem  := rec.refclassid::regclass IN ('pg_language'::regclass, 'pg_namespace'::regclass);
        RETURN NEXT;
      END LOOP;
      RETURN;
    END $$ LANGUAGE plpgsql STABLE;
  --
--

-- Leere Funktion, die beim Kunden mit Skripten gefüllt werden kann. Also nicht einfach per DB-Update aktualisieren, sonst werden Kunden-Skripts überschrieben.
-- vgl. http://redmine.prodat-sql.de/issues/6476
CREATE OR REPLACE FUNCTION TSystem.ExecuteCustomScript(param1 VARCHAR) RETURNS VOID AS $$
  BEGIN
    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--

--- #8477 Wareneingangsbericht : Überarbeitung Anzeige 'Erster WEB für Artikel'
 CREATE OR REPLACE FUNCTION TSystem.wareneingangskontrolle_status(IN _wek_nr INTEGER DEFAULT 0) RETURNS INTEGER AS $$
  DECLARE
    aknr    VARCHAR := '';
    lkrz    VARCHAR := '';
    w_wen   INTEGER := 0;
    anz     INTEGER ; --Definitiv pro Artikel und Lieferant
    custom  INTEGER;

  BEGIN
    --Ausgangs-Datensatz für WEB holen
    SELECT COALESCE(wek_ak_nr, ''), COALESCE(wek_l_krz, ''), COALESCE(wek_w_wen, 0) INTO aknr, lkrz, w_wen FROM wareneingangskontrolle WHERE wek_nr = _wek_nr;

    -- Prüfen ob Auswärtsbearbeitung ~ Für Auswärtsbearbeitungen, WEB-Status nicht anzeigen, laut Ticket 4351
    IF EXISTS(SELECT true FROM wareneingangskontrolle JOIN wendat ON wendat.w_wen = wek_w_wen JOIN ldsdok ON ld_id = w_lds_id WHERE wek_nr = _wek_nr
              AND ld_a2_id IS NOT NULL) OR (aknr='' AND lkrz='') THEN
    RETURN NULL;
    END IF;

    --Kundenspezifische Status-Ausgabe ermöglichen
    custom := TSystem.wareneingangskontrolle_status_custom(_wek_nr);
    IF custom IS NOT NULL THEN
      RETURN custom;
    END IF;

    --Anzahl definitive WEBs für den Artikel in Abhängigkeit vom Lieferant
    SELECT DISTINCT COUNT(wek_nr) OVER (PARTITION BY wek_ak_nr) INTO anz FROM wareneingangskontrolle WHERE wek_ak_nr = aknr AND wek_l_krz = lkrz AND wek_def;
    --fraglich bei dieser Prüfung, ob die Auswärtsbearbeitung eingeschlossen sind oder nicht--aktuell nicht berücksichtigt

    --Es gibt keine definitiven WEBs für den Artikel (unabhängig vom Lieferant)
    IF NOT EXISTS(SELECT DISTINCT COUNT(wek_nr) OVER (PARTITION BY wek_ak_nr) FROM wareneingangskontrolle WHERE wek_ak_nr = aknr AND wek_def) THEN
      --Anzahl der WEBs für den Artikel, abhängig vom Lieferant
      IF (SELECT COUNT(wek_l_krz) FROM (SELECT DISTINCT (wek_l_krz)  FROM wareneingangskontrolle WHERE wek_ak_nr = aknr) AS a )=1 THEN
        RETURN 13228; --"Erster WEB für Artikel"
      END IF;
      --Anzahl definitive WEBs für den Artikel in Abhängigkeit vom Lieferant
      IF (anz IS NULL) THEN
        RETURN 13229; --"Erster WEB für den Artikel bei diesem Lieferant"
      END IF;
    ELSE --Es gibt definitiven WEBs für den Artikel
      IF (anz IS NULL) THEN
        RETURN 13229; --"Erster WEB für den Artikel bei diesem Lieferant"
      END IF;
      --
      RETURN NULL;
    END IF;

  END $$ LANGUAGE plpgsql STABLE;
--

 CREATE OR REPLACE FUNCTION TSystem.wareneingangskontrolle_status_custom(IN _wek_nr INTEGER DEFAULT 0) RETURNS INTEGER AS $$
  BEGIN
  -- Kundenspezifische Funktion für Verwendung in TSystem.wareneingangskontrolle_status
  -- An dieser Stelle als Platzhalter-Funktion bestehen lassen und nur im Kundensystem anpassen
  -- siehe TotalCustomer
    RETURN NULL;
  END $$ LANGUAGE plpgsql STABLE;


-- Extrahiert den Dateinamen aus kompletten Pfad mit Dateinamen.
CREATE OR REPLACE FUNCTION TSystem.Extract_FileName(path_with_filename VARCHAR) RETURNS VARCHAR AS $$
  BEGIN
    RETURN regexp_replace(path_with_filename, E'^.*[/\\\\]', '');
  END $$ LANGUAGE plpgsql IMMUTABLE;
--

--- #9675 Länderkennung Export-Haken
CREATE OR REPLACE FUNCTION tsystem.landiso__zu_Wirtschaftsraum(IN _l_iso VARCHAR) RETURNS VARCHAR AS $$
  BEGIN
   IF (_l_iso IN ('AT', 'BE', 'BG', 'CY', 'CZ', 'DE', 'DK', 'EE', 'ES', 'FI', 'FR', 'GB', 'GR', 'HR', 'HU', 'IE', 'IT', 'LT', 'LU', 'MT', 'NL', 'PL', 'PT', 'RO', 'SE', 'SK'
  /* EWR ?!,'ISL', 'LIE', 'NOR'*/)
  ) THEN
      RETURN 'EU';
   ELSE      --- weitere Landzugehörigkeit, ländergruppen können erweitert werden
      RETURN null;
   END IF;
  END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION TSystem.adk1__update__a1_euexport__a1_export(IN _in_a1_krz VARCHAR) RETURNS VOID AS $$
 DECLARE
         _is_euexport           BOOLEAN;
         _is_export             BOOLEAN;
         _my_WirtschaftRaum      VARCHAR(5);
         _ad_krz_WirtschaftRaum  VARCHAR(5);
 BEGIN
   -- gleiches land, kein export
   IF ( (SELECT ad_landiso FROM adk WHERE ad_krz = '#') = (SELECT ad_landiso FROM adk WHERE ad_krz = _in_a1_krz) ) THEN
     UPDATE adk1
        SET a1_euexport = false,
            a1_export = false
      WHERE a1_krz = _in_a1_krz;

     RETURN;
   END IF;

   _my_WirtschaftRaum     := COALESCE(l_Wirtschaftsraum, '') FROM adk LEFT JOIN laender ON l_iso = ad_landiso WHERE ad_krz = '#';
   _ad_krz_WirtschaftRaum := COALESCE(l_Wirtschaftsraum, '') FROM adk LEFT JOIN laender ON l_iso = ad_landiso WHERE ad_krz = _in_a1_krz;

   -- etweder eu export oder export - nicht beides
   _is_euexport := _my_WirtschaftRaum = 'EU' AND _ad_krz_WirtschaftRaum = 'EU';
   _is_export   := NOT _is_euexport;

   --RAISE NOTICE 'a1_krz = %, _my_WirtschaftRaum = %, _ad_krz_WirtschaftRaum = %, _is_euexport = %, _is_export = %', _in_a1_krz, _my_WirtschaftRaum, _ad_krz_WirtschaftRaum, _is_euexport, _is_export;
   UPDATE adk1 SET a1_euexport = _is_euexport, a1_export = _is_export WHERE a1_krz = _in_a1_krz AND ( a1_euexport IS DISTINCT FROM _is_euexport OR a1_export IS DISTINCT FROM _is_export );
   RETURN;
 END $$ LANGUAGE plpgsql VOLATILE;

-- Connection-Initialisierung (TCimDatabase.DoConnected
CREATE OR REPLACE FUNCTION TSystem.database_settings__initialize(ClientVersion VARCHAR, UserLogin VARCHAR, IsAdmin BOOLEAN) RETURNS TEXT AS $$
  DECLARE txt VARCHAR := '';
          IsUserAdmin BOOLEAN;
  BEGIN
    -- IsAdmin := {DM1.IsSuperAdmin}DM1.IsAdmin or (DM1.Username = ProdatAdminUser);
    BEGIN
      IsUserAdmin := exists(SELECT true FROM TSystem.roles__user__groups__get(UserLogin::VARCHAR) WHERE getusers_groups LIKE '%SYS.Administratoren');
    EXCEPTION WHEN OTHERS THEN
      -- z.B. Prodat-Connection auf "neue" DB, wo Funktionen noch fehlen -> nicht abbrechen, aber Zugriff verweigern
      IsUserAdmin := False;
    END;

    --SET lc_messages = "en_US.UTF-8";  -- ist jetzt in postgresql.conf definiert und wird im Prodat nur noch geprüft ob gesetzt
    --SET lc_monetary = "en_US.UTF-8";  -- siehe THauptForm.OpenDatabaseExecute / TSystem.database_settings__validate()
    --SET lc_numeric  = "en_US.UTF-8";
    --SET lc_time     = "en_US.UTF-8";

    /*IF current_user = 'APPS' THEN  -- current_setting('application_name', True) = 'PRODAT ERP APPS'
      -- siehe TProdatSrvService.ServiceStart wird DORT zur Laufzeit gesetz und nochmal innerhalb von TProdatSrvService.DailyDBFunctions umgeschrieben
      SET statement_timeout = 1200000;  -- 20 min
    ELSEIF*/IF (current_user = 'postgres') OR (UserLogin = 'postgres') THEN
      SET statement_timeout = 0;        -- unendlich, z.B. wenn current_user in DBUpdates (TFormDBUpdates.UpdatesConn) oder bei allen CimConnections wenn ProdatLogin = postgres
    ELSEIF IsUserAdmin OR IsAdmin THEN
      SET statement_timeout = 1200000;  -- 20 min
    ELSE
      SET statement_timeout = 480000;   -- 8 min
    END IF;

    -- aktuelle Client-Verion (UCimRtl.Constants.ProdatClientVersion) / Prodat-DB-Version siehe TSystem.Settings__Get('ProdatVersion')
    -- Abfrage: SELECT SessionVar__get_varchar( _suffix => 'clientversion' )
    PERFORM SessionVar__set_varchar( _suffix => 'clientversion', _value => ClientVersion, _as_tx_var => false );


    -- ClientLogin (DM1.Username) auch in anderen Connections verfügbar (z.B. Syncro)
    PERFORM SessionVar__set_varchar( _suffix => 'userlogin', _value => UserLogin, _as_tx_var => false );

    RETURN nullif(txt, '') || E'\nhttps://redmine.prodat-sql.de/projects/prodat-v-x/wiki/\n0100_postgresql_conf_Datenbankeinstellungen_und_Tuning';  -- und auch als Exception, aber besser via Text
  END $$ LANGUAGE plpgsql;
---

CREATE OR REPLACE FUNCTION tsystem.database__triggers_inaktiv__get(
    IN _all_schemas   boolean = false
    )
    RETURNS TABLE (
      tgname          varchar,
      src_schemaname  varchar,
      src_tablename   varchar,
      trg_schemaname  varchar,
      trg_tablename   varchar
    )
    AS $$
          -- hinweis: cast as varchar nur in pg kleiner 13?!
          SELECT tgname::varchar,
                 src_schema.nspname::varchar  AS src_schemaname,
                 src_table.relname::varchar   AS src_tablename,
                 trg_schema.nspname::varchar  AS trg_schemaname,
                 trg_table.relname::varchar   AS trg_tablename
            FROM pg_trigger
            LEFT JOIN pg_class      AS src_table  ON src_table.oid  = pg_trigger.tgrelid
            LEFT JOIN pg_class      AS trg_table  ON trg_table.oid  = pg_trigger.tgconstrrelid
            LEFT JOIN pg_namespace  AS src_schema ON src_schema.oid = src_table.relnamespace
            LEFT JOIN pg_namespace  AS trg_schema ON trg_schema.oid = trg_table.relnamespace
           WHERE tgenabled = 'D'
             AND (
                  -- Prüfung auf deaktivierte Trigger für alle Schemata
                      _all_schemas
                  -- Prüfung auf deaktivierte Trigger gilt nicht für folg. Schemata
                    -- ignore:    trigger on drop,   fkey: public -> drop, drop -> public, drop -> drop
                    -- relevant:  trigger on public, fkey: public -> public
                  OR  (
                       -- Quelle des deaktivierten Triggers bzw. Contraint-Triggers (fKey) ist nicht in folg. Schemata
                           coalesce( src_schema.nspname, '' ) NOT IN ( 'z_99_drop', 'x_950_import', 'x_900_export' )
                       -- analog für Ziel des Contraint-Triggers (fKey)
                       AND coalesce( trg_schema.nspname, '' ) NOT IN ( 'z_99_drop', 'x_950_import', 'x_900_export' )
                      )
                 )
           ORDER BY tgname
    $$ LANGUAGE sql;


/*  Konfiguriert die Datenbank Settings
    Wird in der Datei "9000 Define\B0 database settings.sql" gerufen, da diese Funktion darf erst nach der Definition der
    Funktion TSystem.dblink__connectionstring__get() gerufen werden darf. */
CREATE OR REPLACE FUNCTION TSystem.database_settings__set() RETURNS void AS $$
    DECLARE _sql text;
            _hardware_size_huge boolean;
            _hardware_size_medium boolean;
    BEGIN

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET log_destination TO ''eventlog'';') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET seq_page_cost TO 5;') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET random_page_cost TO 10;') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET work_mem TO ''256MB'';') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET maintenance_work_mem = ''512MB'';') AS sub (result text);


      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET cursor_tuple_fraction TO 0.75;') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET default_statistics_target = 1000;') AS sub (result text);


      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET log_autovacuum_min_duration TO ''3s'';') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET vacuum_cost_limit TO 1500;') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET checkpoint_timeout TO ''30min'';') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET max_wal_size TO ''10GB'';') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET from_collapse_limit TO 16;') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET join_collapse_limit TO 16;') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET lock_timeout TO 60000;') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET max_locks_per_transaction TO 1024;') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET synchronous_commit TO ''off'';') AS sub (result text);
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET lo_compat_privileges TO ''on'';') AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET lc_messages TO ''en_US.UTF-8'';') AS sub (result text);

      _sql := '"$user",public,TSystem,prodat_languages,Z_99_Deprecated';
      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'ALTER SYSTEM SET search_path TO ' || _sql ) AS sub (result text);

      _hardware_size_huge := EXISTS (SELECT datname FROM pg_database WHERE datname IN ('LOLL-LIVE', 'CIMPCS', 'KREYENBERG') );
      _hardware_size_medium := EXISTS (SELECT datname FROM pg_database WHERE datname IN ('MATTIS-LIVE') );


      IF _hardware_size_huge OR TSystem.Settings__Get('KUNDE') IN ('LOLL', 'KREYENBERG', 'CNC', 'HYDRO') THEN
        _sql := 'ALTER SYSTEM SET effective_cache_size TO ''20GB'';';
      ELSIF _hardware_size_medium THEN
        _sql := 'ALTER SYSTEM SET effective_cache_size TO ''10GB'';';
      ELSE
        _sql := 'ALTER SYSTEM SET effective_cache_size TO ''5GB'';';
      END IF;

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), _sql) AS sub (result text);


      IF _hardware_size_huge THEN  -- 'CNC' hat nur 8 Kerne! Hydro 10!
        _sql := 'ALTER SYSTEM SET max_worker_processes TO 16;';
      ELSIF _hardware_size_medium THEN
        _sql := 'ALTER SYSTEM SET max_worker_processes TO 12;';
      ELSE
        _sql := 'ALTER SYSTEM SET max_worker_processes TO 6;';  -- 8 is default
      END IF;

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), _sql) AS sub (result text);

      IF _hardware_size_huge THEN
        _sql := 'ALTER SYSTEM SET max_parallel_workers TO 18;';
      ELSIF _hardware_size_medium THEN
        _sql := 'ALTER SYSTEM SET max_parallel_workers TO 8;';
      ELSE
        _sql := 'ALTER SYSTEM SET max_parallel_workers TO 4;';
      END IF;

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), _sql) AS sub (result text);

      IF _hardware_size_huge THEN
        _sql := 'ALTER SYSTEM SET max_parallel_workers_per_gather TO 4;';
      ELSE
        _sql := 'ALTER SYSTEM SET max_parallel_workers_per_gather TO 2;';
      END IF;

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), _sql) AS sub (result text);

      PERFORM * FROM dblink(tsystem.dblink__connectionstring__get(), 'SELECT pg_reload_conf()') AS sub (result text);

      RETURN;

    END $$ LANGUAGE plpgsql;


--
CREATE OR REPLACE FUNCTION TSystem.database_settings__validate(
    IN  _is_admin     boolean = false,
        -- alle Schemata = false : Auschluss von 'information_schema', 'pg_catalog', 'z_99_drop', 'import'
        -- wenn true: dann alle Schemata
    IN  _all_schemas  boolean = false
    )
    RETURNS text AS $$
    DECLARE
        -- empty array is distinct from null array
        _messages             text[] = array[]::text[];
        _rec                  record;
        _trigger_message_init boolean = true;
        _tmp                  text;
        _tmp_num              numeric;
    BEGIN
      -- DB-Konfigurationsprüfung (THauptForm.OpenDatabaseExecute)
        -- der ungenutzte _is_admin parameter wird vom prodat übergeben, deswegen muss der vorerst dableiben.
        -- aktuelle Werte für PRODAT-DEMO aus THauptForm.AnalyseDatabaseExecute (Menü > System > Datenbank / Verbindung > Datenbankprüfung)
        -- https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/710_Datenbankeinstellungen_und_Tuning_(postgresql_conf)
      IF current_setting( 'log_destination' ) IS DISTINCT FROM 'eventlog' THEN
          _messages := _messages || 'log_destination <> eventlog'::text;
      END IF;

      IF current_setting( 'seq_page_cost', true ) IS DISTINCT FROM '5' THEN
          _messages := _messages || 'seq_page_cost <> 5'::text;
      END IF;

      IF current_setting( 'random_page_cost', true ) IS DISTINCT FROM '10' THEN
          _messages := _messages || 'random_page_cost <> 10'::text;
      END IF;

      IF current_setting( 'cursor_tuple_fraction', true ) IS DISTINCT FROM '0.75' THEN
          _messages := _messages || 'cursor_tuple_fraction <> 0.75'::text;
      END IF;

      IF current_setting( 'lc_messages', true ) IS DISTINCT FROM 'en_US.UTF-8' THEN
          -- englische Fehlermeldung für Übersetzung in Oberfläche (Query.OnPortError > DM1.HandlePostError) / Query Planning
          _messages := _messages || 'lc_messages <> "en_US.UTF-8"'::text;
      END IF;

      SELECT current_setting( 'shared_buffers', true ) INTO _tmp;

      _tmp_num := --SELECT -- table_name,
                         -- ,pg_relation_size(quote_ident(table_name)) / 1024
                         round(sum(pg_total_relation_size(quote_ident(table_name)) / 1024^3) * 1.5) --GB
                         -- ,pg_size_pretty(pg_total_relation_size(quote_ident(table_name)))
                    FROM information_schema.tables
                   WHERE table_name in ('art', 'auftg', 'ldsdok', 'lag', 'stv', 'recnokeyword', 'ab2') -- einfach aus dem Bauch
                     AND table_schema NOT LIKE 'pg_%'
                     AND table_schema NOT IN ('z_99_drop');

      IF NOT _tmp ILIKE '%GB' OR LEFT(_tmp, length(_tmp) - 2)::numeric < _tmp_num THEN -- GB abschneiden!
          _messages := _messages || ('shared_buffers NOT GB or to low see "FUNCTION TSystem.database_settings__validate" SELECTED GB:'::varchar || _tmp_num::text)::text; -- erstes varchar wegen KEIN Zeilenumbruch
      END IF;

      IF current_setting( 'work_mem', true ) IS DISTINCT FROM '256MB' THEN
          _messages := _messages || 'work_mem <> 256MB'::text;
      END IF;

      IF current_setting( 'effective_cache_size', true ) = '4GB' THEN
          _messages := _messages || 'effective_cache_size < 8GB'::text;
      END IF;

      IF current_setting( 'log_autovacuum_min_duration', true ) IS DISTINCT FROM '3s' THEN
          _messages := _messages || 'log_autovacuum_min_duration <> 3s'::text;
      END IF;

      IF current_setting( 'vacuum_cost_limit', true ) IS DISTINCT FROM '1500' THEN
          _messages := _messages || 'vacuum_cost_limit <> 1500'::text;
      END IF;

      IF current_setting( 'checkpoint_timeout', true ) IS DISTINCT FROM '30min' THEN
          _messages := _messages || 'checkpoint_timeout <> 30min'::text;
      END IF;

      IF current_setting( 'max_wal_size', true ) IS DISTINCT FROM '10GB' THEN
          _messages := _messages || 'max_wal_size <> 10GB'::text;
      END IF;

      IF current_setting( 'max_parallel_workers_per_gather', true ) = '0' THEN
          _messages := _messages || 'max_parallel_workers_per_gather = 0'::text;
          _messages := _messages || 'NO PARALLEL Query > see Wiki'::text;
      END IF;

      IF current_setting( 'from_collapse_limit', true ) < '16' THEN
          _messages := _messages || 'from_collapse_limit < 16'::text;
      END IF;

      IF current_setting( 'join_collapse_limit', true ) < '16' THEN
          _messages := _messages || 'join_collapse_limit < 16'::text;
      END IF;
      IF (SELECT setting FROM pg_settings WHERE name = 'lock_timeout') < 60000 THEN -- direkte Abfrage wegen Zeiteinheit ms!
          _messages := _messages || 'lock_timeout should be 60000 (ms) or higher)'::text;
      END IF;

      IF current_setting( 'max_locks_per_transaction', true ) < 1024 THEN
          _messages := _messages || 'max_locks_per_transaction < 1024'::text;
      END IF;

      IF current_setting( 'fsync', true ) <> 'on' THEN
          _messages := _messages || 'fsync <> on'::text;
      END IF;

      IF current_setting( 'synchronous_commit', true ) <> 'off' THEN
          _messages := _messages || 'synchronous_commit <> off'::text;
      END IF;

      IF current_setting( 'lo_compat_privileges', false ) <> 'on' THEN -- wegen no-superuser
          _messages := _messages || 'lo_compat_privileges <> on'::text;
      END IF;

      IF lower(replace(current_setting( 'search_path', true ), ' ', '')) <> lower('"$user",public,TSystem,prodat_languages,Z_99_Deprecated') THEN
          _messages := _messages || 'search_path <> ''"$user",public,TSystem,prodat_languages,Z_99_Deprecated'''::text;
      END IF;

      -- Prüfung deaktivierter Trigger, siehe #15307
      FOR _rec IN
          SELECT *
            FROM tsystem.database__triggers_inaktiv__get(_all_schemas)
      LOOP

          -- Meldungen für deaktivierte Trigger initialisieren
          IF _trigger_message_init THEN

              _messages := _messages || 'disabled trigger:'::text;
              _trigger_message_init := false;

          END IF;

          -- Meldung anfügen bzgl. deaktivieren Trigger an Schema.Tabelle
          _messages := _messages || ( '    ' || _rec.tgname ||' on '|| _rec.src_schemaname || '.' || _rec.src_tablename )::text;

      END LOOP;

      _tmp := string_agg(usename, ';') FROM pg_user WHERE usesuper AND NOT (TSystem.roles__user__group__is_in(usename::varchar, 'SYS.SuperUser') ) AND usename  NOT IN ('root', 'postgres', 'syncro', 'APPS', 'TC-ADMIN', 'DEMODATA', 'docker', 'Administrator', 'Administratoren', 'SYS.dblink'); -- Administrator wegen PG13 auf Windows Autovacuum läuft unter diesem Account wenn PG als Admin installiert
      IF trim(_tmp) <> '' THEN
        _messages := _messages || ( 'Invalid Superusers: ' || _tmp );
      END IF;

      -- Wir checken direkt dblink
      BEGIN
              PERFORM * FROM dblink(tsystem.dblink__connectionstring__get( ), 'SELECT true'
                              ) AS sub (result boolean);
      EXCEPTION
         WHEN OTHERS THEN
           _messages := _messages || ( sqlerrm || 'check "pg_hba_file_rules" -> user SYS.dblink. db_link and unprivileged rights (https://redmine.prodat-sql.de/issues/18002)')::text;
      END;
      BEGIN
         PERFORM * FROM dblink('host=localhost port=' || inet_server_port()::integer || ' dbname=' || current_database() || ' user=APPS password=Application-Server', 'SELECT true'
                              ) AS sub (result boolean);
      EXCEPTION
         WHEN OTHERS THEN
           _messages := _messages || ( sqlerrm || 'check "pg_hba_file_rules" -> user APPS need to be at least md5 on local (best: adress "all")  connections because of db_link and unprivileged rights (https://redmine.prodat-sql.de/issues/18002)')::text;
      END;

      -- Superuser -> konkret korrekt prüfen!
      IF (SELECT usesuper FROM pg_user WHERE usename = CURRENT_USER) THEN

          -- APPS, syncro dürfen NIE trust sein
          IF EXISTS( SELECT true
                       FROM pg_hba_file_rules
                      WHERE (   array_position( user_name, 'syncro'::text ) > 0 -- benutzer direkt benannt
                             OR array_position( user_name, 'APPS'::text ) > 0
                             OR array_position( user_name, 'all'::text ) > 0    -- einfach alle user md5
                            )
                        AND (array_position( database, 'all' )  > 0  OR array_position( database, current_database()::text ) > 0)
                        AND auth_method IN ('trust')
                    )
          THEN
              _messages := _messages || 'pg_hba_file_rules: user {APPS,syncro} need to be at least md5 NEVER TRUST on all connections because of db_link and unprivileged rights (https://redmine.prodat-sql.de/issues/18002)'::text;
          END IF;

          -- postgres muss trust sein, da aktuelle backup/restore scripts davon ausgehen! IP - V4
          IF NOT EXISTS( SELECT true
                           FROM pg_hba_file_rules
                          WHERE address IN ('127.0.0.1')
                            AND array_position( user_name, 'postgres'::text ) > 0
                            AND (array_position( database, 'all' )  > 0  OR array_position( database, current_database()::text ) > 0)
                            AND auth_method IN ('trust')
                        )
          THEN
              _messages := _messages || 'pg_hba_file_rules: user {postgres} need to be / MUST TRUST for *127.0.0.1* (ipv4) because of backup restore scripts and so on'::text;
          END IF;

          -- postgres muss trust sein, da aktuelle backup/restore scripts davon ausgehen! IP - V6
          IF NOT EXISTS( SELECT true
                           FROM pg_hba_file_rules
                          WHERE address IN ('::1')
                            AND array_position( user_name, 'postgres'::text ) > 0
                            AND (array_position( database, 'all' )  > 0  OR array_position( database, current_database()::text ) > 0)
                            AND auth_method IN ('trust')
                        )
          THEN
              _messages := _messages || 'pg_hba_file_rules: user {postgres} need to be / MUST TRUST for *::1* (ipv6) because of backup restore scripts and so on'::text;
          END IF;

      END IF;

      -- prodat expects null if everthing is set correctly
      IF ( cardinality( _messages ) = 0 ) THEN  -- cardinality => _messages wird als Array interpretiert
          RETURN null;
      END IF;

      _messages := _messages || ''::text;
      _messages := _messages || '!!!!  SELECT TSystem.database_settings__set();  !!!! => https://redmine.prodat-sql.de/projects/prodat-v-x/wiki/710_Datenbankeinstellungen_und_Tuning_(postgresql_conf)'::text;


      RETURN array_to_string( _messages, E'\n' );
    END $$ LANGUAGE plpgsql;
--

----------------------------
-- Wrapper für set_config --
----------------------------

-- set - interne Funktion! Bitte die anderen Datentyp gebundenen Funktionen verwenden.
SELECT tsystem.function__drop_by_regex( 'SessionVar__set', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__set(
  IN prefix      text,
  IN suffix      text,
  IN new_value   text,
  IN is_local    boolean
  ) RETURNS text
  AS $$
      SELECT set_config( /*setting_name =>*/ ( prefix || '.' || suffix ), /*new_value =>*/ new_value, /*is_local =>*/ is_local )
  $$ LANGUAGE sql;

-- set varchar
SELECT tsystem.function__drop_by_regex( 'SessionVar__set_varchar', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__set_varchar(
  IN _suffix     varchar,
  IN _value      varchar,
  IN _as_tx_var  boolean   DEFAULT true, -- "tx" steht für "Transaktion"; true -> Variable gültig in Transaktion; false -> gültig in Session
  IN _prefix     varchar   DEFAULT 'prodat'
  ) RETURNS varchar
  AS $$
      SELECT TSystem.SessionVar__set( prefix => _prefix::text, suffix => _suffix::text, new_value => _value::text, is_local => _as_tx_var )::varchar
  $$ LANGUAGE sql;

-- set boolean
SELECT tsystem.function__drop_by_regex( 'SessionVar__set_boolean', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__set_boolean(
  IN _suffix     varchar,
  IN _value      boolean,
  IN _as_tx_var  boolean   DEFAULT true, -- "tx" steht für "Transaktion"; true -> Variable gültig in Transaktion; false -> gültig in Session
  IN _prefix     varchar   DEFAULT 'prodat'
  ) RETURNS boolean
  AS $$
      SELECT TSystem.SessionVar__set( prefix => _prefix::text, suffix => _suffix::text, new_value => _value::text, is_local => _as_tx_var )::boolean
  $$ LANGUAGE sql;

-- set integer
SELECT tsystem.function__drop_by_regex( 'SessionVar__set_integer', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__set_integer(
  IN _suffix     varchar,
  IN _value      integer,
  IN _as_tx_var  boolean   DEFAULT false, -- "tx" steht für "Transaktion"; true -> Variable gültig in Transaktion; false -> gültig in Session
  IN _prefix     varchar   DEFAULT 'prodat'
  ) RETURNS integer
  AS $$
      SELECT TSystem.SessionVar__set( prefix => _prefix::text, suffix => _suffix::text, new_value => _value::text, is_local => _as_tx_var )::integer
  $$ LANGUAGE sql;

-- set numeric
SELECT tsystem.function__drop_by_regex( 'SessionVar__set_numeric', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__set_numeric(
  IN _suffix     varchar,
  IN _value      numeric,
  IN _as_tx_var  boolean   DEFAULT false, -- "tx" steht für "Transaktion"; true -> Variable gültig in Transaktion; false -> gültig in Session
  IN _prefix     varchar   DEFAULT 'prodat'
  ) RETURNS numeric
  AS $$
      SELECT TSystem.SessionVar__set( prefix => _prefix::text, suffix => _suffix::text, new_value => _value::text, is_local => _as_tx_var )::numeric
  $$ LANGUAGE sql;


-- get - interne Funktion! Bitte die anderen Datentyp gebundenen Funktionen verwenden.
SELECT tsystem.function__drop_by_regex( 'SessionVar__get', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__get(
  IN prefix      text,
  IN suffix      text,
  IN missing_ok  boolean   DEFAULT true
  ) RETURNS text
  AS $$
      SELECT current_setting( /*setting_name =>*/ ( prefix || '.' || suffix ), /*missing_ok =>*/ missing_ok )
  $$ LANGUAGE sql;

-- get varchar
-- SELECT tsystem.function__drop_by_regex( 'sessionvar__get_varchar', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.sessionvar__get_varchar(
  IN _suffix     varchar,
  IN _default    varchar   DEFAULT null::varchar,
  IN _prefix     varchar   DEFAULT 'prodat',
  IN _missing_ok boolean   DEFAULT true
  ) RETURNS varchar
  AS $$
      SELECT coalesce( TSystem.SessionVar__get( prefix => _prefix::text, suffix => _suffix::text, missing_ok => _missing_ok )::varchar, _default::varchar )
  $$ LANGUAGE sql;

-- get boolean
SELECT tsystem.function__drop_by_regex( 'SessionVar__get_boolean', 'TSystem', _commit => true );
SELECT tsystem.function__drop_by_regex( 'SessionVar__get_bool', 'TSystem', _commit => true ); -- Alter Funktionsname
CREATE OR REPLACE FUNCTION TSystem.SessionVar__get_boolean(
  IN _suffix     varchar,
  IN _default    boolean   DEFAULT null::boolean,
  IN _prefix     varchar   DEFAULT 'prodat',
  IN _missing_ok boolean   DEFAULT true
  ) RETURNS boolean
  AS $$
      -- Für Ordinale-Datentypen Value Leerstring als NULL behandeln (nullif).
      SELECT coalesce( nullif( TSystem.SessionVar__get( prefix => _prefix::text, suffix => _suffix::text, missing_ok => _missing_ok ), '' )::boolean, _default::boolean )
  $$ LANGUAGE sql;

-- get integer
SELECT tsystem.function__drop_by_regex( 'SessionVar__get_integer', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__get_integer(
  IN _suffix     varchar,
  IN _default    integer   DEFAULT null::integer,
  IN _prefix     varchar   DEFAULT 'prodat',
  IN _missing_ok boolean   DEFAULT true
  ) RETURNS integer
  AS $$
      -- Für Ordinale-Datentypen Value Leerstring als NULL behandeln (nullif).
      SELECT coalesce( nullif( TSystem.SessionVar__get( prefix => _prefix::text, suffix => _suffix::text, missing_ok => _missing_ok ), '' )::integer, _default::integer )
  $$ LANGUAGE sql;

-- get numeric
SELECT tsystem.function__drop_by_regex( 'SessionVar__get_numeric', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__get_numeric(
  IN _suffix     varchar,
  IN _default    numeric   DEFAULT null::numeric,
  IN _prefix     varchar   DEFAULT 'prodat',
  IN _missing_ok boolean   DEFAULT true
  ) RETURNS numeric
  AS $$
      -- Für Ordinale-Datentypen Value Leerstring als NULL behandeln (nullif).
      SELECT coalesce( nullif( TSystem.SessionVar__get( prefix => _prefix::text, suffix => _suffix::text, missing_ok => _missing_ok ), '' )::numeric, _default::numeric )
  $$ LANGUAGE sql;


-- increment
SELECT tsystem.function__drop_by_regex( 'SessionVar__increment_integer', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__increment_integer(
  IN _suffix     varchar,
  IN _amount     integer   DEFAULT 1,
  IN _startvalue integer   DEFAULT 0,
  IN _as_tx_var  boolean   DEFAULT true,
  IN _prefix     varchar   DEFAULT 'prodat'
  ) RETURNS integer
  AS $$
      SELECT  TSystem.SessionVar__set_integer(
                  _prefix     => _prefix
                , _suffix     => _suffix
                , _value      => TSystem.SessionVar__get_integer( _prefix => _prefix, _suffix => _suffix, _default => _startvalue ) + _amount
                , _as_tx_var  => _as_tx_var
              )
  $$ LANGUAGE sql;

-- decrement
SELECT tsystem.function__drop_by_regex( 'SessionVar__decrement_integer', 'TSystem', _commit => true );
CREATE OR REPLACE FUNCTION TSystem.SessionVar__decrement_integer(
  IN _suffix     varchar,
  IN _amount     integer   DEFAULT 1,
  IN _startvalue integer   DEFAULT 0,
  IN _as_tx_var  boolean   DEFAULT true,
  IN _prefix     varchar   DEFAULT 'prodat'
  ) RETURNS integer
  AS $$
      SELECT  TSystem.SessionVar__set_integer(
                  _prefix     => _prefix
                , _suffix     => _suffix
                , _value      => TSystem.SessionVar__get_integer( _prefix => _prefix, _suffix => _suffix, _default => _startvalue ) - _amount
                , _as_tx_var  => _as_tx_var
              )
  $$ LANGUAGE sql;
--


--
CREATE OR REPLACE FUNCTION tsystem.times_to_tsrange(
  IN _time1      TIME(0) WITHOUT TIME ZONE,
  IN _time2      TIME(0) WITHOUT TIME ZONE,
  IN _date       DATE    DEFAULT NULL,
  IN span_right  BOOLEAN DEFAULT true -- Range wird nach rechts (+ 1 Tag) oder links (-1 Tag) aufgespannt, wenn Start > Ende.
                                     -- rechts: Für Vergleich von tsrange über DateTimes (bdep) mit Times am Tag (tplan): 21.07.1980 22:00 - 22.07.1980 05:00 mit Tagesplan 22:00 - 04:00 vom 21.07.1980
                                     -- links:  Für Vergleich von tsrange über Times ohne Tag (tplan, tplanpause): Ist feste Pause 02:00 - 03:00 im Tagesplan 22:00 - 04:00?
  ) RETURNS tsrange
  AS $$
  BEGIN
    IF (_time1 IS NULL AND _time2 IS NULL) THEN  RETURN NULL; END IF; -- nur eins NULL dann unendliches Intervall

    _date := COALESCE(_date, '1980-07-21');

    RETURN tsrange (
      _date + CASE WHEN NOT span_right AND _time1 > _time2 THEN -1 ELSE 0 END + _time1, -- links:  1 Tag ab,    falls über Tagesgrenze (Start > Ende)
      _date + CASE WHEN     span_right AND _time1 > _time2 THEN +1 ELSE 0 END + _time2  -- rechts: 1 Tag drauf, falls über Tagesgrenze (Start > Ende)
    );

  END $$ LANGUAGE plpgsql IMMUTABLE;
--

-- Über einen Zeitabschnitt zwischen 2 Timestamps, die Summe der Schnittmengen zwischen allen Abständen der Intervalle holen in Stunden.
-- setup RHE
CREATE OR REPLACE FUNCTION tsystem.get_timerange_intersection_duration(
  IN _range1 tsrange,
  IN _range2 tsrange
  ) RETURNS NUMERIC(12,4)
  AS $$
  BEGIN
    -- bei keiner überlappung 0 tage
    IF NOT ( _range1 && _range2 ) THEN
        RETURN 0;
    END IF;

    -- zeit in sekunden
    RETURN extract ( epoch FROM upper( _range1 * _range2 ) - lower( _range1 * _range2 ) );

  END $$ LANGUAGE plpgsql IMMUTABLE;
--

-- Die Schnittmenge/Intersect zwischen 2 Zeitabschnitten erzeugen. Die Ausgabe erfolgt in Stunden.
CREATE OR REPLACE FUNCTION tsystem.timestamps__intervals__intersect(
  IN timestamp_start TIMESTAMP WITHOUT TIME ZONE,
  IN timestamp_end   TIMESTAMP WITHOUT TIME ZONE,
  IN interval_start  INTERVAL,
  IN interval_end    INTERVAL,
  IN step_length     INTERVAL DEFAULT '1 day'::INTERVAL
  ) RETURNS NUMERIC
  AS $$
  DECLARE _offset_nightshift_start INTERVAL;
          _offset_nightshift_end INTERVAL;
  BEGIN
    IF ( interval_start IS NULL OR interval_end IS NULL ) THEN
        RETURN 0;
    END IF;

    -- wenn interval_start < interval_end dann muss der start in den
    -- vorherigen tag verschoben werden
    IF ( interval_start <= interval_end ) THEN
        _offset_nightshift_start := interval_start;
        _offset_nightshift_end   := interval_end;
    ELSE
        _offset_nightshift_start := -step_length + interval_start;
        _offset_nightshift_end   := interval_end;
    END IF;

    RETURN (
      WITH _data AS (
          SELECT
            dates + _offset_nightshift_start  AS d_start,
            dates + _offset_nightshift_end    AS d_end
          FROM generate_series(
                  date_trunc( 'day', timestamp_start ) - step_length,
                  date_trunc( 'day', timestamp_end )   + step_length,
                  step_length
          ) AS t( dates )
      )
      SELECT
        sum(
          tsystem.get_timerange_intersection_duration( -- gets overlapse in seconds
            tsrange( timestamp_start, timestamp_end ),
            tsrange( d_start, d_end )
          ) / 3600
        )
      FROM _data
    );

  END $$ LANGUAGE plpgsql STABLE;
--

-- Zusatzfunktion zum Auslesen der XTT-Texte
CREATE OR REPLACE FUNCTION TSystem.translate_xtt(in_txt IN TEXT) RETURNS TEXT
  AS $$
  DECLARE
     _substr     TEXT;
     _lang_txt   TEXT;
     _xtt_substr INTEGER;
     _out_txt    TEXT;
     parts_array TEXT[];
  BEGIN
    IF in_txt IS NULL THEN
      RETURN in_txt;
    END IF;

    -- Notwendig falls mehr als 1 txt
    parts_array := regexp_split_to_array(in_txt, ',') ;

    -- über alle gefundenen Texte
    FOR   i in 1 ..  array_upper(parts_array, 1) LOOP
      -- prüfen ob xtt vorhanden
      IF regexp_matches(parts_array[i], '.*xtt[0-9]+$') IS NOT NULL THEN
        _substr := substr(parts_array[i], strpos(parts_array[i], 'xtt'));
        _xtt_substr := substr(parts_array[i], strpos(parts_array[i], 'xtt')+3)::INTEGER;
        _lang_txt := prodat_languages.lang_text(_xtt_substr);

        -- wenn keine Übersetzung gefunden - Originaltxt aus Array anfügen
        IF _substr = _lang_txt THEN
          _out_txt := concat(COALESCE(_out_txt || ', ', ''), parts_array[i]);
        ELSE
          -- ausformuliertes xtt gefunden
          _out_txt := concat(COALESCE(_out_txt || ', ', ''), _lang_txt);
        END IF;
      ELSE
        -- kein xtt gefunden, auch Originaltxt aus Array anfügen
        _out_txt := concat(COALESCE(_out_txt || ', ', ''), parts_array[i]);
      END IF;
    END LOOP;
    RETURN _out_txt;
  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION tsystem.date__extract_end_date( _point_in_time timestamp ) RETURNS date AS $$
  BEGIN

      -- Diese Funktion gibt für timestamps mit einem Zeitanteil von '00:00:00' den _anderen_
      -- zugehörigen tag Zurück. Das ist vorallem bei Oberflächen Nützlich wenn wir einen Zeitraum
      -- von Montag bis Freitag betrachten, der jeweils von/bis Mitternacht geht.

      --  08:19:15 » HER@pg.prodat-sql.de:5432/PRODAT-DEMO # SELECT
      --  2 - »   '2020-02-24 00:00:00' as _start,
      --  3 - »   '2020-02-29 00:00:00' as _end
      --  4 - » \gset date

      --  08:19:27 » HER@pg.prodat-sql.de:5432/PRODAT-DEMO # SELECT
      --  2 - »   lang_text( 17 + extract( dow FROM :'date_start'::timestamp )::int ) as a,
      --  3 - »   lang_text( 17 + tsystem.date__extract_end_date_dow( :'date_end'::timestamp ) ) as b
      --  4 - » ;
      -- ┌────────┬─────────┐
      -- │   a    │    b    │
      -- ╞════════╪═════════╡
      -- │ Montag │ Freitag │
      -- └────────┴─────────┘

      -- at midnigt return the date before
      IF ( age( _point_in_time, _point_in_time::date ) = '00:00:00'::time ) THEN
          RETURN _point_in_time::date - '1 day'::interval;
      END IF;

      RETURN _point_in_time::date;

  END $$ LANGUAGE plpgsql PARALLEL SAFE STRICT IMMUTABLE;

CREATE OR REPLACE FUNCTION tsystem.date__extract_end_date_dow( _point_in_time timestamp ) RETURNS int AS $$

  SELECT extract( dow FROM tsystem.date__extract_end_date( _point_in_time ) )::int;

  $$ LANGUAGE sql IMMUTABLE;
--

/*  Ermittelt die Monatsdifference zwischen zwei Datumsangaben.

    Dabei ist nur entscheidend, in welchem Kalendermont und Jahr die beiden Daten sind.
    31.12.2021 - 01.01.2022 = 1   vs.   01.01.2021 - 31.01.2021 = 0

    Wenn das End- vor dem Startdatum liegt, wird der Wert negativ. Ist mindestens ein Datum null ist das Ergbenis auch null. */
CREATE OR REPLACE FUNCTION TSystem.date__monthdifference( _enddate date, _startdate date ) RETURNS integer AS $$
  SELECT
  (
    ( ( date_part( 'YEAR', _enddate )::int - date_part( 'YEAR', _startdate )::int ) * 12 ) +
    ( date_part( 'MONTH', _enddate )::int - date_part( 'MONTH', _startdate )::int )
  )::int
$$ LANGUAGE sql IMMUTABLE;
--

--
CREATE OR REPLACE FUNCTION TSystem.f2poss__condition__get(
    f2id              integer,

    OUT field_name    varchar,
    OUT field_value   varchar
  ) RETURNS record AS $$
  DECLARE
      rec varchar[];
  BEGIN
      -- Extrahiert Fieldname und FieldValue aus [AdditionalParams]-Sektion der f2_config per f2_id


      rec :=
            -- folgende Formate sind möglich:
              -- condition = (:field_name = 'value')
              -- condition = :field_name = value
              -- condition = field_name = value
            regexp_matches(
                -- INI-Werte von Parameter 'condition' aus Section 'AdditionalParams' in INI f2_config auslesen.
                tsystem.ini_getvalue(
                    f2_config,
                    'AdditionalParams',
                    'condition'
                ),
                -- Format-Prüfung
                  -- beachte regex capturing groups 1 und 2
                E'\\(?\\s*:?(\\w*)\\s*=\\s*\\47?(\\w*)\\47?\\s*\\)?', -- \47 - Hochkomma
                -- s: non-newline-sensitive matching
                -- i: case-insensitive matching
                'si'
            )
          FROM f2poss
          WHERE f2_id = f2id
      ;

      -- Ergebnisse aus capturing group 1 (Feld) und 2 (Wert)
      field_name  := rec[1];
      field_value := rec[2];


      RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--


-- 'ab2' AS menu_tablename => menu_tablenmae('ab2') > um in pg96 und pg13 gleichermaßen varchar zurückzubekommen
-- pg13 gibt text zurück, pg96 unknown
CREATE OR REPLACE FUNCTION tsystem.menu_tablename(IN _tname text)
  RETURNS varchar
    AS $$
      SELECT _tname::varchar
    $$ LANGUAGE sql IMMUTABLE;

-- menu_tablename(ab2) ohne "magic string"
CREATE OR REPLACE FUNCTION tsystem.menu_tablename(IN _table anyelement)
  RETURNS varchar
    AS $$
      SELECT pg_typeof(_table)::varchar
    $$ LANGUAGE sql IMMUTABLE;


--
CREATE OR REPLACE FUNCTION TSystem.termweek__format( _termweek varchar ) RETURNS varchar AS $$
  BEGIN
    -- Kalenderwoche formatieren und Format überprüfen.


    -- Nur die Kalenderwoche ist angegeben,
      -- dann aktuelles Jahr davorsetzen
    IF _termweek ~ '^[0-5][0-9]$' THEN
        RETURN extract( year FROM current_date )::varchar || _termweek;
    END IF;

    -- Nur Kalenderwoche mit vorgesetztem KW ist angegeben,
      -- dann vorgesetztes KW ersetzen mit aktuellem Jahr
    IF _termweek ~ '^[Kk][Ww][0-5][0-9]$' THEN
        RETURN regexp_replace( _termweek, '[Kk][Ww]', extract( year FROM current_date )::varchar );
    END IF;


    -- Validierung
      -- Termin Woche entspricht nicht dem Format YYYYKW
    IF
            _termweek IS NOT null
        AND _termweek !~ '^[1-2][0-9]{3}[0-5][0-9]$'
    THEN
        -- Fehlermeldung mit Angabe der erlaubten Varianten
        RAISE EXCEPTION '% %, %, %',
            lang_text( 20074 ),
            -- Varianten
            -- vollständige Eingabe YYYYWW '202039'
            week_of_year( current_date ),
            -- Eingabe KW 'KW39'
            'KW' || extract( week FROM current_date )::varchar,
            -- Eingabe nur KW-Nummer '39'
            extract( week FROM current_date )::varchar
        ;
    END IF;


    RETURN _termweek;
END $$ LANGUAGE plpgsql;
--

--- #17067
CREATE OR REPLACE FUNCTION TSystem.dms__notify__changes() RETURNS boolean AS $$
 BEGIN

    RETURN (
             ( SELECT current_user NOT IN ( 'ELO', 'DMS-SYNC-USER', 'syncro', 'APPS', 'postgres' ) )
             AND NOT TSystem.Settings__GetBool( 'DMS__DISABLE__NOTIFY__CHANGES' )
           );

END $$ LANGUAGE plpgsql;
--- #16950
CREATE OR REPLACE FUNCTION TSystem.grant__table_funktion_sequence_schema_privileg__to__rolle(
    IN _to_role varchar DEFAULT 'SYS.Prodat-User'
    )
    RETURNS void
    AS $$
    DECLARE _schema varchar;
            _r record;
    BEGIN

      -- Ticket 76

      -- https://dba.stackexchange.com/questions/192529/how-can-i-grant-permissions-on-tables-created-in-the-future-to-members-of-a-part
      -- If you want the user2, or userN, who has role my_role to have access to the future tables of user1, you must run the code below under user1 (who creates new tables),
      -- because ALTER DEFAULT PRIVILEGES... works only for objects by that user under whom you run ALTER DEFAULT PRIVILEGES...

      FOR _schema IN SELECT schema_name FROM information_schema.schemata
                      WHERE NOT schema_name LIKE 'pg_%'
                        AND     schema_name NOT IN ('information_schema','tsystem_security')
                        -- tsystem_security schema has its own very strict permissions, DO NOT TOUCH, see \1000-interfaces\1000-DelegatedLogin\99 Permissions.sql
       LOOP

          EXECUTE 'GRANT EXECUTE                        ON ALL FUNCTIONS IN SCHEMA ' || quote_ident(_schema) || ' TO ' || quote_ident(_to_role) || ';';
          EXECUTE 'GRANT USAGE                          ON ALL SEQUENCES IN SCHEMA ' || quote_ident(_schema) || ' TO ' || quote_ident(_to_role) || ';';
          EXECUTE 'GRANT USAGE                          ON SCHEMA '                  || quote_ident(_schema) || ' TO ' || quote_ident(_to_role) || ';';

          EXECUTE 'GRANT ALL PRIVILEGES                 ON ALL TABLES    IN SCHEMA ' || quote_ident(_schema) || ' TO ' || quote_ident(_to_role) || ';';
          EXECUTE 'GRANT ALL PRIVILEGES                 ON ALL SEQUENCES IN SCHEMA ' || quote_ident(_schema) || ' TO ' || quote_ident(_to_role) || ';';
          EXECUTE 'GRANT ALL PRIVILEGES                 ON ALL FUNCTIONS IN SCHEMA ' || quote_ident(_schema) || ' TO ' || quote_ident(_to_role) || ';';

          EXECUTE 'ALTER DEFAULT PRIVILEGES IN SCHEMA '                              || quote_ident(_schema) || ' GRANT ALL PRIVILEGES ON TABLES    TO ' || quote_ident(_to_role) || ';';
          EXECUTE 'ALTER DEFAULT PRIVILEGES IN SCHEMA '                              || quote_ident(_schema) || ' GRANT ALL PRIVILEGES ON SEQUENCES TO ' || quote_ident(_to_role) || ';';
          EXECUTE 'ALTER DEFAULT PRIVILEGES IN SCHEMA '                              || quote_ident(_schema) || ' GRANT ALL PRIVILEGES ON FUNCTIONS TO ' || quote_ident(_to_role) || ';';

          RAISE NOTICE 'grant__table_funktion_sequence_schema_privileg__to__rolle:%', _schema;

      END LOOP;

      -- TCache > Materialized Views werden vom Client angelegt. Daher vollzugriff auf das Schema
      EXECUTE 'GRANT CREATE ON SCHEMA tcache TO '     || quote_ident(_to_role) || ';';

      -- pg_stat_statement und activity usw.
      EXECUTE 'GRANT pg_read_all_stats TO '                              || quote_ident('SYS.Administratoren') || ';';

      EXECUTE 'GRANT ALL PRIVILEGES ON pg_file_settings TO '             || quote_ident('SYS.Administratoren') || ';';
      EXECUTE 'GRANT EXECUTE ON FUNCTION pg_show_all_file_settings TO '  || quote_ident('SYS.Administratoren') || ';';



      -- SYS.Administratoren und SYS.Personaldaten haben das Recht Benutzer anzulegen!
      PERFORM TSystem.grant__createrole__privileg__to__rolles();

    END $$ LANGUAGE plpgsql;


  CREATE OR REPLACE FUNCTION TSystem.grant__createrole__privileg__to__rolles()
    RETURNS void
    AS $$
    DECLARE _r record;
    BEGIN
        -- SYS.Administratoren und SYS.Personaldaten haben das Recht Benutzer anzulegen!
        FOR _r IN SELECT DISTINCT usename FROM pg_group JOIN pg_user ON usesysid = ANY(grolist) WHERE groname IN ('SYS.Administratoren', 'SYS.Personaldaten') AND NOT usesuper
        LOOP
            EXECUTE 'ALTER USER "' || _r.usename || '" WITH CREATEROLE';
        END LOOP;

    END $$ LANGUAGE plpgsql;

  ---

  CREATE OR REPLACE FUNCTION TSystem.Text0_AutoTextNr__setting_values__get(
             IN _s_vari varchar(70),
            OUT save_time timestamp with time zone,
            OUT nr_mode integer,
            OUT last_nr integer
          ) RETURNS record AS $$
  DECLARE
    s_value varchar;
    s_value_time varchar;
  BEGIN
    s_value = TSystem.Settings__Get(_s_vari);
    s_value_time = split_part(s_value, '|', 1);
    IF   (s_value_time = '0')
      OR (s_value_time = '')
      OR (s_value_time IS NULL)
    THEN
      s_value_time = to_char(current_timestamp, 'YYMMDDHH24MISS');
    END IF;

    save_time = to_timestamp(s_value_time, 'YYMMDDHH24MISS');
    nr_mode   = coalesce(nullif(split_part(s_value, '|', 2), ''), '0')::INT;
    last_nr   = coalesce(nullif(split_part(s_value, '|', 3), ''), '0')::INT;

    RETURN;

  END $$ LANGUAGE plpgsql STABLE;
  ---

CREATE OR REPLACE FUNCTION tsystem.table_fields__dbrid_insert_modified__drop(
    IN _schema_name           varchar,
    IN _Table_list_array      varchar[] default null       --- Tabellenliste, wo Tabellenstruktur-Korrektur passieren soll
    )
    RETURNS void AS $$
    DECLARE rec      record;
            _sql     varchar;
    BEGIN
        _sql := 'SELECT table_schema, table_name FROM information_schema.tables WHERE table_type = ''BASE TABLE'' ';
        IF char_length( trim( _schema_name ) ) > 0 THEN
          _sql := _sql || chr( 10 ) || '  AND table_schema = ' || quote_literal( _schema_name );
        END IF;

        IF array_length( _Table_list_array, 1 ) > 0 THEN
          _sql := _sql || chr( 10 ) || '  AND coalesce( array_position( ' || quote_literal( _Table_list_array ) || '::varchar[], table_name::varchar ), 0 ) > 0';
        END IF;

        FOR rec IN EXECUTE _sql
        LOOP
            _sql := 'ALTER TABLE IF EXISTS ' || _schema_name || '.' || rec.table_name ||
                   E'\n     DROP COLUMN IF EXISTS dbrid,' ||
                   E'\n     DROP COLUMN IF EXISTS insert_date,' ||
                   E'\n     DROP COLUMN IF EXISTS insert_by,' ||
                   E'\n     DROP COLUMN IF EXISTS modified_date,' ||
                   E'\n     DROP COLUMN IF EXISTS modified_by;';
            raise notice '%', _sql;
            EXECUTE _sql;
            EXECUTE 'DROP TRIGGER IF EXISTS ' || rec.table_name || '_table_detele ON ' || _schema_name || '.' || rec.table_name;
            EXECUTE 'DROP TRIGGER IF EXISTS ' || rec.table_name || '_set_modified ON ' || _schema_name || '.' || rec.table_name;
         END LOOP;
    END $$ language plpgsql;
---
---  #20663
CREATE OR REPLACE FUNCTION TSystem.Sequencen_Nummerkreis__restart( IN _date date default current_date ) RETURNS VOID AS $$
 DECLARE _sql              varchar;
         _YY               varchar := to_char( _date, 'YY' );
         _nc_num_start     varchar := '100';
 BEGIN
    --- Restart soll automatisch (von Betriebssysteme) ausgeführt werden
    IF TSystem.Equals( to_char( _date, 'DD-MM-YY' )::varchar, '01-01-' || _YY )    --- nur am 01.01._YY
        AND substring( (SELECT last_value FROM ldsdok_ld_dokunr_seq)  FROM 3 FOR 2 ) <> _YY             --- nur einmal ausführen
    THEN
        _sql := 'ALTER SEQUENCE ldsdok_ld_dokunr_seq            RESTART WITH 27' || _YY || '00' || _nc_num_start || ';';   --Bestelldokument
        EXECUTE _sql;
        raise notice '%', _sql;
        ---

        _sql := 'ALTER SEQUENCE auswlog_aw_dokunr_seq           RESTART WITH 28' || _YY || '00' || _nc_num_start || ';';   --Auswärtsvergabe-Dokument
        EXECUTE _sql;
        raise notice '%', _sql;
        ---

        _sql := 'ALTER SEQUENCE auftg_ag_dokunr__astat_a__seq   RESTART WITH 31' || _YY || '00' || _nc_num_start || ';';   --Angebotsdokument
        EXECUTE _sql;
        raise notice '%', _sql;
        ---

        _sql := 'ALTER SEQUENCE auftg_ag_dokunr_seq             RESTART WITH 33' || _YY || '00' || _nc_num_start || ';';   --Auftragsdokument
        EXECUTE _sql;
        raise notice '%', _sql;

        --- Nummerkreis restart
        UPDATE numcircles SET nc_num = nc_num_start WHERE nc_num_restart;

    END IF;
 END $$ LANGUAGE plpgsql;
---
--- #21589
--Prueft ob Benutzer in einer gruppe ist
DROP FUNCTION IF EXISTS TSystem.roles__user__group__is_in;
CREATE OR REPLACE FUNCTION TSystem.roles__user__group__is_in( _rolname varchar, VARIADIC _groupname varchar[] ) RETURNS boolean AS $$
 BEGIN
    RETURN ( SELECT EXISTS (
                             SELECT true FROM (
                                                WITH RECURSIVE cte AS (
                                                                        SELECT oid, pg_roles.rolname, null::name AS parent, IFTHEN(pg_roles.rolcanlogin, -1, 0) AS depth
                                                                          FROM pg_roles
                                                                         WHERE rolname = _rolname
                                                                         --AND rolname NOT LIKE 'SYS.MANDANT.' || current_database()
                                                                         UNION ALL
                                                                        SELECT m.roleid, r.rolname, cte.rolname, depth + 1
                                                                          FROM cte
                                                                          JOIN pg_auth_members m ON m.member = cte.oid
                                                                          JOIN pg_roles r ON r.oid = m.roleid
                                                                         WHERE depth < 1 -- Gruppe in Gruppe nur 1 Dimensional derzeit wegen Undurchschaubarkeit! Daher auch die folgenden beiden Bedingungen auskommentiert!
                                                                           -- AND r.rolname NOT LIKE 'SYS.Administratoren' -- sonst ist die direkte Abfrage nach "user in sys.administrator" immer false
                                                                           -- AND r.rolname NOT LIKE 'SYS.MANDANT%' -- Da Administrator idR alles beinhaltet, hier aufhören
                                                                      )
                                                SELECT rolname AS rolename
                                                  FROM cte
                                              ) AS sub
                              WHERE rolename = ANY( _groupname )
                          )
           );

 END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;

--- #21589
/*Funktion die zu einem Hauptmenupunkt zurückgibt, ob die Parent alle Sichtbar sind*/
 CREATE OR REPLACE FUNCTION TSystem.roles__user__groups__get__allcolumns( _rolname varchar, OUT rolname varchar, OUT rol_inheritfrom varchar) RETURNS SETOF record
    AS $$

      WITH RECURSIVE cte AS (
                              SELECT oid, pg_roles.rolname, null::name AS rol_inheritfrom, NOT pg_roles.rolcanlogin AS isgroup, IFTHEN(pg_roles.rolcanlogin, -1, 0) AS depth
                                FROM pg_roles
                               WHERE rolname = _rolname
                               UNION
                              SELECT m.roleid, r.rolname, cte.rolname AS rol_inheritfrom, NOT r.rolcanlogin AS isgroup, depth + 1
                                FROM cte
                                JOIN pg_auth_members m ON m.member = cte.oid
                                JOIN pg_roles r ON r.oid = m.roleid
                               WHERE NOT r.rolcanlogin -- nur Gruppe in Gruppe auflösen. Nicht User reinziehen, die in einer untergeordneten Gruppe enthalten sind!
                                 AND depth < 1
                                 AND r.rolname NOT LIKE 'SYS.Administratoren' -- Da Administrator idR alles beinhaltet, hier aufhören
                                 -- AND r.rolname NOT LIKE 'SYS.MANDANT%' -- Da Administrator idR alles beinhaltet, hier aufhören

                            )
            -- debug: SELECT * FROM cte
            SELECT DISTINCT CASE WHEN isgroup THEN '~' ELSE '' END || rolname /*, isgroup*/ AS rolename,
                   string_agg(NullIf(rol_inheritfrom, _rolname)::varchar, ';') AS inheritfrom
              FROM cte
             WHERE true -- rolname NOT ILIKE 'SYS.MANDANT.%' -- Mandantenrollen ausschliessen (kommen durch SYS.Administratoren rekursiv für alle rein)
               -- AND rolname <> _rolname -- wir müssen uns auch selbst zurückgeben, da CheckExplizitAccess davon ausgeht.
             GROUP BY isgroup, rolname
             UNION
            -- wenn ich selbst eine gruppe bin, dann meine direkt zugeordneten Gruppen (die nicht rekursiv aufgelöst werden, da dann rekursiv alle User der Gruppe reingezogen würden sein könnten)
            SELECT --r.rolname AS role_name,
                   CASE WHEN NOT r2.rolcanlogin THEN '~' ELSE '' END || r2.rolname AS member_name,
                   null::varchar
              FROM pg_auth_members m
              JOIN pg_roles r ON r.oid = m.roleid
              JOIN pg_roles r2 ON r2.oid = m.member
             WHERE r.rolname =  _rolname
             UNION
            -- Mandantenrollen, denen ich direkt zugewiesen bin
            SELECT '~' || rolname,
                   null::varchar
              FROM pg_auth_members m -- mein eigener Mandant explizit aufnehmen bzw ich bin SYS.Administrator
              JOIN pg_roles r ON r.oid = m.roleid
             WHERE m.member = (SELECT oid FROM pg_roles WHERE rolname = _rolname)
                -- Mandantenrollen, denen ich direkt zugewiesen bin, anzeigen. Mandantenrollen, die nur durch SYS.Administrator (also Gruppe in Grupp) zugewiesen, werden oben zuerst ausgefiltert.
               AND ((rolname LIKE 'SYS.MANDANT.%' ) OR (rolname LIKE 'SYS.Administratoren'))
             ORDER BY rolename

    $$ LANGUAGE sql STABLE PARALLEL SAFE;

 DROP FUNCTION IF EXISTS TSystem.roles__user__groups__get;
 CREATE OR REPLACE FUNCTION TSystem.roles__user__groups__get( _rolname varchar ) RETURNS SETOF varchar
    AS $$
      SELECT rolname FROM TSystem.roles__user__groups__get__allcolumns( _rolname );
    $$ LANGUAGE sql STABLE PARALLEL SAFE;
--


--- #21589
-- Prueft, ob Benutzer in der Gruppe Personaldaten ist // Später Gruppe mit Rolle ersetzen
CREATE OR REPLACE FUNCTION TSystem.roles__user__rights_personal(
        _usename varchar,
        _role    varchar
    ) RETURNS boolean AS $$
 BEGIN
     IF _role = '' THEN
      RETURN TSystem.roles__user__group__is_in( _usename, _role, 'SYS.Personaldaten' );   --Personal gesamt
     END IF;

     IF _role = 'PrivTel' THEN
      RETURN TSystem.roles__user__group__is_in( _usename, _role, 'SYS.Personaldaten.PrivTel' );   --Nur private Telefonnummern
     END IF;

     IF _role = 'AbwBewill.ALohneRecht' THEN
      RETURN TSystem.roles__user__group__is_in( _usename, _role, 'SYS.Personaldaten.AbwBewill.ALohneRecht' );
    END IF;
 END $$ LANGUAGE plpgsql STABLE;
---
/***** Start: Funktionen für HTTP-Abfragen: #21558, #20728 *****/
-- Grundfunktion für alle HTTP-Methoden
SELECT tsystem.function__drop_by_regex( 'http_request', 'tsystem', _commit => true );
CREATE OR REPLACE FUNCTION tsystem.http_request(
        _request      http_request,
        _while_count  integer DEFAULT 3,    -- Anzahl While-Schleifen
        _pg_sleep     integer DEFAULT 1     -- Dauer der Pause vor der nächsten While-Schleife ( in Sekunden )
    ) RETURNS http_response AS $$
  DECLARE
      _response         http_response;
      _curlopt_cainfo   varchar := TSystem.Settings__GetText( 'HTTP-curl-ca-bundle-PATH' );
      _i                integer := 0;
      _status           integer := 0;
      _root_log_id      bigint := TSystem.LogInfo(
                                      message   =>  format(
                                                        'call: tsystem.http_request( _request => %s, _while_count => %s, _pg_sleep => %s )'
                                                      ,                              _request      , _while_count      , _pg_sleep
                                                    )
                                    , logtype   =>  'pltDebugging'
                                  );

  BEGIN

      --- Prüfen ob ein Pfad zur Liste der vertauenswürdigen CAs konfiguriert wurde.
      IF coalesce( _curlopt_cainfo, '' ) = '' THEN
          RAISE EXCEPTION 'Setting HTTP-curl-ca-bundle-PATH ist nicht konfiguriert!';
      END IF;

      PERFORM http_set_curlopt('CURLOPT_CAINFO', _curlopt_cainfo );

      WHILE _i < _while_count and _status <> 200 LOOP

          -- Zwischen den Schleifendurchläufen warten.
          IF _i>0 THEN
              PERFORM pg_sleep( _pg_sleep );
          END IF;

          _i := _i + 1;

          SELECT http.*
          INTO _response
          FROM http( request => _request );

          _status = _response.status;

          PERFORM TSystem.LogHTTPRequest(
                      request   => _request
                    , response  => _response
                    , loopcnt   => _i
                    , parent_id => _root_log_id
                  )
          ;

      END LOOP;

      RETURN _response;

  END $$ LANGUAGE plpgsql;
--

-- Funktion für HTTP-GET-Abfragen
SELECT tsystem.function__drop_by_regex( 'http_get_request', 'tsystem', _commit => true );
CREATE OR REPLACE FUNCTION tsystem.http_get_request(
      _uri                  varchar,
      _data                 jsonb     DEFAULT null,
      _while_count          integer   DEFAULT 3,     -- Anzahl WHILE-Schritte
      _pg_sleep             integer   DEFAULT 1      -- Pause vor nexte WHILE-Schritt ( in Sekunden )
) RETURNS http_response AS $$

      SELECT http_request.*
      FROM tsystem.http_request(
                _request      =>  (
                                      /*method => */      'GET'
                                    , /*uri =>*/          CASE WHEN _data IS null THEN _uri ELSE _uri || '?' || urlencode( _data ) END
                                    , /*headers =>*/      NULL
                                    , /*content_type =>*/ NULL
                                    , /*content =>*/      NULL
                                  )::http_request
              , _while_count  => _while_count
              , _pg_sleep     => _pg_sleep
            )

  $$ LANGUAGE sql;
--

-- Funktionen für HTTP-POST-Abfragen
SELECT tsystem.function__drop_by_regex( 'http_post_request', 'tsystem', _commit => true );
CREATE OR REPLACE FUNCTION tsystem.http_post_request(
      _uri                  varchar,
      _content              varchar,
      _content_type         varchar,
      _while_count          integer   DEFAULT 3,     -- Anzahl WHILE-Schritte
      _pg_sleep             integer   DEFAULT 1      -- Pause vor nexte WHILE-Schritt ( in Sekunden )
) RETURNS http_response AS $$

      SELECT http_request.*
      FROM tsystem.http_request(
                _request      =>  (
                                      /*method => */      'POST'
                                    , /*uri =>*/          _uri
                                    , /*headers =>*/      NULL
                                    , /*content_type =>*/ _content_type
                                    , /*content =>*/      _content
                                  )::http_request
              , _while_count  => _while_count
              , _pg_sleep     => _pg_sleep
            )

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION tsystem.http_post_request(
      _uri                  varchar,
      _data                 jsonb,
      _while_count          integer   DEFAULT 3,     -- Anzahl WHILE-Schritte
      _pg_sleep             integer   DEFAULT 1      -- Pause vor nexte  WHILE-Schritt ( in Sekunden )
) RETURNS http_response AS $$

      SELECT http_request.*
      FROM tsystem.http_request(
                _request      =>  (
                                      /*method => */      'POST'
                                    , /*uri =>*/          _uri
                                    , /*headers =>*/      NULL
                                    , /*content_type =>*/ 'application/x-www-form-urlencoded'
                                    , /*content =>*/      urlencode( _data )
                                  )::http_request
              , _while_count  => _while_count
              , _pg_sleep     => _pg_sleep
            )

  $$ LANGUAGE sql;
--
/***** Ende: Funktionen für HTTP-Abfragen: #21558, #20728 *****/

--- #21945
CREATE OR REPLACE FUNCTION TSystem.trigger__enable(
      IN _tablename   varchar,
      IN _triggername varchar = 'ALL'
  ) RETURNS void AS $$
  DECLARE
      _sql varchar;
  BEGIN
      _sql := format( 'ALTER TABLE %s ENABLE TRIGGER %s', _tablename, _triggername );
      EXECUTE _sql;
      PERFORM LogWarning( message => _sql );

      RETURN;
  END $$ LANGUAGE plpgsql SECURITY DEFINER;

ALTER FUNCTION TSystem.trigger__enable( varchar, varchar ) OWNER TO postgres;
---
CREATE OR REPLACE FUNCTION TSystem.trigger__disable(
      IN _tablename   varchar,
      IN _triggername varchar = 'ALL'
  ) RETURNS void AS $$
  DECLARE
      _sql varchar;
  BEGIN
      _sql := format( 'ALTER TABLE %s DISABLE TRIGGER %s', _tablename, _triggername );
      EXECUTE _sql;
      PERFORM LogWarning( message => _sql );

      RETURN;
  END $$ LANGUAGE plpgsql SECURITY DEFINER;

ALTER FUNCTION TSystem.trigger__disable(varchar, varchar) OWNER TO postgres;



CREATE OR REPLACE FUNCTION TSystem.ReAssignOwnedBy(
    IN _from_user varchar,
    IN _to_user varchar = 'postgres'
    ) RETURNS void AS $$
 BEGIN
    EXECUTE format('REASSIGN OWNED BY %I TO %I', _from_user, _to_user);
    RETURN;
 END $$ LANGUAGE plpgsql SECURITY DEFINER;
ALTER FUNCTION TSystem.ReAssignOwnedBy( varchar, varchar ) OWNER TO postgres;

-- --- #21945 Ende


CREATE OR REPLACE FUNCTION TSystem.view__combined__create(
  IN schema_name varchar,
  IN view1_name varchar,
  IN view2_name varchar,
  IN result_view_name varchar
  )
  RETURNS void
  AS $$
  DECLARE
    cols_view1 TEXT[];
    cols_view2 TEXT[];
    final_cols TEXT[];
    col TEXT;
    sql TEXT;
  BEGIN
    -- Spalten aus View1 holen
    SELECT array_agg(column_name::TEXT)
    INTO cols_view1
    FROM information_schema.columns
    WHERE table_schema = schema_name
      AND table_name = view1_name;

    -- Spalten aus View2 holen
    SELECT array_agg(column_name::TEXT)
    INTO cols_view2
    FROM information_schema.columns
    WHERE table_schema = schema_name
      AND table_name = view2_name;

    -- Initialisierung der finalen Spaltenliste
    final_cols := '{}';

    -- Spalten aus View1 (v1) übernehmen
    FOREACH col IN ARRAY cols_view1 LOOP
        final_cols := array_append(final_cols, format('v1.%s AS %s', col, col));
    END LOOP;

    -- Nur Spalten aus View2 (v2) übernehmen, die nicht bereits in View1 enthalten sind
    FOREACH col IN ARRAY cols_view2 LOOP
        IF NOT col = ANY(cols_view1) THEN
            final_cols := array_append(final_cols, format('v2.%s AS %s', col, col));
        END IF;
    END LOOP;

    -- SQL-Befehl zusammenbauen
    sql := format(
        'CREATE OR REPLACE VIEW %s.%s AS
         SELECT %s
         FROM %s.%s v1
         INNER JOIN %s.%s v2 ON v1.p_id = v2.p_id;',
        schema_name,
        result_view_name,
        array_to_string(final_cols, ', '),
        schema_name,
        view1_name,
        schema_name,
        view2_name
    );

    -- Logging des SQL-Statements
    RAISE NOTICE 'Generated SQL: %', sql;

    -- SQL ausführen
    EXECUTE sql;
  END $$ LANGUAGE plpgsql;


-- Folgende Funktionen tree__...() Bottom-Up-Rekursion
-- #22871 Holt rekursiv alle IDs aus einem Baumarray ab (z. B. alle Vorfahren)
CREATE OR REPLACE FUNCTION tsystem.tree__recursive_array_ids__get(
    IN _ids            integer[],    --- Array von Knoten-IDs
    IN _parent_ids     integer[],    --- Array von Parent-IDs, entspricht _ids positionsweise
    IN _start_id       integer,      --- Start-ID für die Rekursion
    IN _sort_order     varchar default 'ASC'    --- Sortierreihenfolge ('ASC' oder 'DESC') für die Ausgabe
    ) RETURNS integer[] 
    AS $$
    DECLARE
        result_ids integer[];
    BEGIN
        -- Datenquelle vorbereiten: ID und Parent-ID als Zeilen
        WITH RECURSIVE
        data AS (
            SELECT unnest(_ids) AS id, unnest(_parent_ids) AS parent_id
        ),
        -- Rekursive CTE zur Ermittlung der Baumstruktur
        tree_cte AS (
            SELECT id, parent_id, ARRAY[id] AS path
            FROM data
            WHERE id = _start_id

            UNION ALL

            SELECT d.id, d.parent_id, c.path || d.id
            FROM data d
            INNER JOIN tree_cte c ON d.id = c.parent_id
            WHERE NOT d.id = ANY(c.path) -- Zyklen verhindern
        )
        -- IDs aggregieren und sortieren nach Vorgabe
        SELECT array_agg(id ORDER BY
            CASE WHEN UPPER(_sort_order) = 'ASC'  THEN id ELSE NULL END ASC,
            CASE WHEN UPPER(_sort_order) = 'DESC' THEN id ELSE NULL END DESC
        )
        INTO result_ids
        FROM tree_cte;

        RETURN result_ids;
    END $$ LANGUAGE plpgsql;
--

-- Erzeugt aus IDs eine textuelle Pfaddarstellung (z. B. Kategorie / Unterkategorie ...)
CREATE OR REPLACE FUNCTION tsystem.tree__id__parent_path_get(
    IN _table_name varchar,
    IN _schema_name varchar,
    IN _fname_id varchar,                  -- Feldname der ID-Spalte
    IN _result_ids integer[],              -- Reihenfolge der IDs für die Darstellung
    IN _out_fields varchar[],              -- Felder für Pfadanzeige
    IN _separator varchar DEFAULT ' -> ',  -- optionale Angabe Pfadseparator
    OUT _result varchar                    -- Rückgabewert – zusammengesetzter Pfad
    ) AS $$
    DECLARE
        _sql text;
        _prepared_select text[];
        _prepared_concat text[];
        _field text;
        _field_final text;
        _alias text;
        i int := 1;
    BEGIN
        -- Leere ID-Liste behandeln
        IF _result_ids IS NULL OR array_length(_result_ids, 1) = 0 THEN
            _result := '';
            RETURN;
        END IF;
        
        -- SELECT-Felder vorbereiten, inkl. Aliasnamen (col1, col2, ...)
        FOREACH _field IN ARRAY _out_fields
        LOOP
            IF _field ~ '^[a-zA-Z_][a-zA-Z0-9_]*$' THEN
                _field_final := 't.' || _field;
            ELSE
                _field_final := _field;
            END IF;

            _alias := 'col' || i::text;
            i := i + 1;

            _prepared_select := array_append(_prepared_select, format('%s AS %I', _field_final, _alias));
            _prepared_concat := array_append(_prepared_concat, _alias);
        END LOOP;
        
        -- Dynamisches SQL aufbauen zur Generierung des Pfades
        _sql := format(
            $f$
            WITH ids AS (
                SELECT unnest($1) AS _id
            )
            SELECT string_agg(concat_ws(' / ', %s), $2)
            FROM (
                SELECT %s
                FROM ids i
                JOIN %I.%I t ON t.%I = i._id
            ) sub
            $f$,
            array_to_string(_prepared_concat, ', '),
            array_to_string(_prepared_select, ', '),
            _schema_name,
            _table_name,
            _fname_id
        );

        EXECUTE _sql USING _result_ids, _separator INTO _result;
    END $$ LANGUAGE plpgsql;
--

-- Kombinierte Funktion – rekursive IDs ermitteln und daraus Pfadtext generieren
CREATE OR REPLACE FUNCTION TSystem.tree__structure__get(
    IN _table_name        varchar,                -- Tabellenname mit Baumstruktur
    IN _schema_name       varchar,                  
    IN _fname_id          varchar,                 -- Feldname der ID-Spalte
    IN _fname_parent_id   varchar,                 -- Feldname Parent-ID-Spalte oder Funktion bspw.'auftg_get_auftgmainpos(t.ag_id)',
    IN _start_id_value    integer,                 -- Startpunkt im Baum
    IN _sort_order        varchar,                 -- Sortierreihenfolge
    IN _out_field         varchar[],               -- Ausgabefelder, die in der Darstellung erscheinen sollen. Bei coalesce-Verwendung soll aliase t benutzen (Z.Bsp. 'coalesce( lang_text( t.sd_vartxtnr ), t.sd_settingsname, t.sd_name )')             
    IN _separator         varchar DEFAULT ' -> '   -- optionale Angabe Pfadseparator
    ) RETURNS varchar 
    AS $$
    DECLARE
        _result               varchar := '';
        _sql                  text;
        _array_ids            integer[];
        _array_parent_ids     integer[];
        _result_ids           integer[];
        _is_function          boolean;
    BEGIN
        -- Prüfen, ob _fname_parent_id wie eine Funktion aussieht
        _is_function := position('(' in _fname_parent_id) > 0;
        
        -- IDs und Parent-IDs aus Tabelle extrahieren
        IF _is_function THEN
            -- dynamische SQL mit Funktionsausdruck (setzt voraus, dass Tabelle als Alias 't' benutzt wird)
            _sql := format(
                'SELECT array_agg(t.%1$I)::integer[], array_agg(%2$s)::integer[] FROM %3$I.%4$I t',
                _fname_id, _fname_parent_id, _schema_name, _table_name
            );
        ELSE
            -- reguläre Spaltennamen
            _sql := format(
                'SELECT array_agg(t.%1$I)::integer[], array_agg(t.%2$I)::integer[] FROM %3$I.%4$I t',
                _fname_id, _fname_parent_id, _schema_name, _table_name
            );
        END IF;

        -- Ausführen der dynamischen SQL
        EXECUTE _sql INTO _array_ids, _array_parent_ids;

        -- Rekursive IDs ermitteln
        _result_ids := tsystem.tree__recursive_array_ids__get(
            _ids         => _array_ids,
            _parent_ids  => _array_parent_ids,
            _start_id    => _start_id_value,
            _sort_order  => _sort_order
        );

        -- Pfadtext mit Separator erzeugen
        _result := TSystem.tree__id__parent_path_get(
            _table_name  => _table_name,
            _schema_name => _schema_name,
            _fname_id    => _fname_id,
            _result_ids  => _result_ids,
            _out_fields  => _out_field,
            _separator   => _separator  
        );

        RETURN _result;
    END $$ LANGUAGE plpgsql STABLE;
--